/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.ExtensibleHandler;
import org.apache.james.protocols.api.handler.LineHandler;
import org.apache.james.protocols.api.handler.WiringException;
import org.apache.james.protocols.smtp.MailEnvelope;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.AbstractHookableCmdHandler;
import org.apache.james.protocols.smtp.core.DataCmdHandler;
import org.apache.james.protocols.smtp.core.DataLineFilter;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookResultHook;
import org.apache.james.protocols.smtp.hook.MessageHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataLineMessageHookHandler
implements DataLineFilter,
ExtensibleHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataLineMessageHookHandler.class);
    private static final Response ERROR_PROCESSING_MESSAGE = new SMTPResponse("451", DSNStatus.getStatus(4, "0.0") + " Error processing message").immutable();
    private List<?> messageHandlers;
    private List<?> rHooks;

    @Override
    public Response onLine(SMTPSession session, ByteBuffer line, LineHandler<SMTPSession> next) {
        MailEnvelope env = (MailEnvelope)session.getAttachment(DataCmdHandler.MAILENV, ProtocolSession.State.Transaction).orElseThrow(() -> new RuntimeException("'" + DataCmdHandler.MAILENV.asString() + "' has not been filled."));
        OutputStream out = this.getMessageOutputStream(env);
        try {
            byte c = line.get();
            if (line.remaining() == 2 && c == 46) {
                out.flush();
                out.close();
                Response response = this.processExtensions(session, env);
                session.popLineHandler();
                session.resetState();
                return response;
            }
            if (c == 46 && line.get() == 46) {
                byte[] bline = this.readBytes(line);
                out.write(bline, 1, bline.length - 1);
            } else {
                out.write(this.readBytes(line));
            }
            out.flush();
        }
        catch (IOException e) {
            LOGGER.error("Unknown error occurred while processing DATA.", (Throwable)e);
            session.resetState();
            return ERROR_PROCESSING_MESSAGE;
        }
        return null;
    }

    private OutputStream getMessageOutputStream(MailEnvelope env) {
        try {
            return env.getMessageOutputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] readBytes(ByteBuffer line) {
        byte[] bline;
        line.rewind();
        if (line.hasArray()) {
            bline = line.array();
        } else {
            bline = new byte[line.remaining()];
            line.get(bline);
        }
        return bline;
    }

    protected Response processExtensions(SMTPSession session, MailEnvelope mail) {
        if (this.messageHandlers != null) {
            for (Object messageHandler : this.messageHandlers) {
                SMTPResponse response;
                MessageHook rawHandler = (MessageHook)messageHandler;
                LOGGER.debug("executing message handler {}", (Object)rawHandler);
                long start = System.currentTimeMillis();
                HookResult hRes = rawHandler.onMessage(session, mail);
                long executionTime = System.currentTimeMillis() - start;
                if (this.rHooks != null) {
                    for (Object rHook : this.rHooks) {
                        LOGGER.debug("executing hook {}", rHook);
                        hRes = ((HookResultHook)rHook).onHookResult(session, hRes, executionTime, rawHandler);
                    }
                }
                if ((response = AbstractHookableCmdHandler.calcDefaultSMTPResponse(hRes)) == null) continue;
                return response;
            }
            return AbstractHookableCmdHandler.calcDefaultSMTPResponse(HookResult.DECLINED);
        }
        return null;
    }

    public void wireExtensions(Class interfaceName, List extension) throws WiringException {
        if (MessageHook.class.equals((Object)interfaceName)) {
            this.messageHandlers = extension;
            this.checkMessageHookCount(this.messageHandlers);
        } else if (HookResultHook.class.equals((Object)interfaceName)) {
            this.rHooks = extension;
        }
    }

    protected void checkMessageHookCount(List<?> messageHandlers) throws WiringException {
        if (messageHandlers.isEmpty()) {
            throw new WiringException("No messageHandler configured");
        }
    }

    public List<Class<?>> getMarkerInterfaces() {
        LinkedList classes = new LinkedList();
        classes.add(MessageHook.class);
        classes.add(HookResultHook.class);
        return classes;
    }
}

