/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import java.util.ArrayList;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.base.AbstractImapCommandParser;
import org.apache.james.imap.message.request.EnableRequest;

public class EnableCommandParser
extends AbstractImapCommandParser {
    public EnableCommandParser(StatusResponseFactory statusResponseFactory) {
        super(ImapConstants.ENABLE_COMMAND, statusResponseFactory);
    }

    @Override
    protected ImapMessage decode(ImapRequestLineReader request, Tag tag, ImapSession session) throws DecodingException {
        ArrayList<Capability> caps = new ArrayList<Capability>();
        caps.add(Capability.of(request.astring()));
        while (request.nextChar() == ' ') {
            request.consume();
            caps.add(Capability.of(request.astring()));
        }
        request.eol();
        return new EnableRequest(tag, caps);
    }
}

