/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.quota;

import java.util.Optional;
import java.util.function.Function;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaLimitValue;
import org.apache.james.core.quota.QuotaSizeLimit;

public class QuotaCodec {
    private static final long INFINITE = -1L;
    private static final long NO_RIGHT = 0L;

    static Long quotaValueToLong(QuotaLimitValue<?> value) {
        if (value.isUnlimited()) {
            return -1L;
        }
        return value.asLong();
    }

    static Optional<QuotaSizeLimit> longToQuotaSize(Long value) {
        return QuotaCodec.longToQuotaValue(value, QuotaSizeLimit.unlimited(), QuotaSizeLimit::size);
    }

    static Optional<QuotaCountLimit> longToQuotaCount(Long value) {
        return QuotaCodec.longToQuotaValue(value, QuotaCountLimit.unlimited(), QuotaCountLimit::count);
    }

    private static <T extends QuotaLimitValue<T>> Optional<T> longToQuotaValue(Long value, T infiniteValue, Function<Long, T> quotaFactory) {
        if (value == null) {
            return Optional.empty();
        }
        if (value == -1L) {
            return Optional.of(infiniteValue);
        }
        if (QuotaCodec.isInvalid(value)) {
            return Optional.of((QuotaLimitValue)quotaFactory.apply(0L));
        }
        return Optional.of((QuotaLimitValue)quotaFactory.apply(value));
    }

    private static boolean isInvalid(Long value) {
        return value < -1L;
    }
}

