/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.identity;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.model.EmailAddress;
import org.apache.james.jmap.api.model.HtmlSignature$;
import org.apache.james.jmap.api.model.Identity;
import org.apache.james.jmap.api.model.IdentityId;
import org.apache.james.jmap.api.model.TextSignature$;
import org.apache.james.rrt.api.CanSendFrom;
import org.apache.james.user.api.UsersRepository;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnceOps;
import scala.collection.convert.StreamExtensions;
import scala.collection.immutable.List;
import scala.jdk.StreamConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005I4A\u0001C\u0005\u0001-!AQ\u0004\u0001B\u0001B\u0003%a\u0004\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003'\u0011\u0015i\u0003\u0001\"\u0001/\u0011\u0015a\u0004\u0001\"\u0001>\u0011\u0015A\u0006\u0001\"\u0001Z\u0011\u0015\u0019\u0007\u0001\"\u0001e\u0011\u0015Y\u0007\u0001\"\u0003m\u0005]!UMZ1vYRLE-\u001a8uSRL8+\u001e9qY&,'O\u0003\u0002\u000b\u0017\u0005A\u0011\u000eZ3oi&$\u0018P\u0003\u0002\r\u001b\u0005\u0019\u0011\r]5\u000b\u00059y\u0011\u0001\u00026nCBT!\u0001E\t\u0002\u000b)\fW.Z:\u000b\u0005I\u0019\u0012AB1qC\u000eDWMC\u0001\u0015\u0003\ry'oZ\u0002\u0001'\t\u0001q\u0003\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0004B]f\u0014VMZ\u0001\fG\u0006t7+\u001a8e\rJ|W\u000e\u0005\u0002 G5\t\u0001E\u0003\u0002\rC)\u0011!eD\u0001\u0004eJ$\u0018B\u0001\u0013!\u0005-\u0019\u0015M\\*f]\u00124%o\\7\u0002\u001fU\u001cXM]:SKB|7/\u001b;pef\u0004\"aJ\u0016\u000e\u0003!R!\u0001D\u0015\u000b\u0005)z\u0011\u0001B;tKJL!\u0001\f\u0015\u0003\u001fU\u001bXM]:SKB|7/\u001b;pef\fa\u0001P5oSRtDcA\u00182eA\u0011\u0001\u0007A\u0007\u0002\u0013!)Qd\u0001a\u0001=!)Qe\u0001a\u0001M!\u00121\u0001\u000e\t\u0003kij\u0011A\u000e\u0006\u0003oa\na!\u001b8kK\u000e$(\"A\u001d\u0002\u000b)\fg/\u0019=\n\u0005m2$AB%oU\u0016\u001cG/\u0001\bmSN$\u0018\nZ3oi&$\u0018.Z:\u0015\u0005y\u0002\u0006cA H\u0015:\u0011\u0001)\u0012\b\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u0007V\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000e\n\u0005\u0019K\u0012a\u00029bG.\fw-Z\u0005\u0003\u0011&\u0013A\u0001T5ti*\u0011a)\u0007\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001b.\tQ!\\8eK2L!a\u0014'\u0003\u0011%#WM\u001c;jifDQ!\u0015\u0003A\u0002I\u000b\u0001\"^:fe:\fW.\u001a\t\u0003'Zk\u0011\u0001\u0016\u0006\u0003+>\tAaY8sK&\u0011q\u000b\u0016\u0002\t+N,'O\\1nK\u0006yQo]3s\u0007\u0006t7+\u001a8e\rJ|W\u000eF\u0002[;z\u0003\"\u0001G.\n\u0005qK\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006#\u0016\u0001\rA\u0015\u0005\u0006?\u0016\u0001\r\u0001Y\u0001\f[\u0006LG.\u00113ee\u0016\u001c8\u000f\u0005\u0002TC&\u0011!\r\u0016\u0002\f\u001b\u0006LG.\u00113ee\u0016\u001c8/A\njgN+'O^3s'\u0016$\u0018\nZ3oi&$\u0018\u0010F\u0002[K\u001aDQ!\u0015\u0004A\u0002ICQa\u001a\u0004A\u0002!\f!!\u001b3\u0011\u0005-K\u0017B\u00016M\u0005)IE-\u001a8uSRL\u0018\nZ\u0001\u0005MJ|W\u000e\u0006\u0002naB\u0019\u0001D\u001c5\n\u0005=L\"AB(qi&|g\u000eC\u0003r\u000f\u0001\u0007\u0001-A\u0004bI\u0012\u0014Xm]:")
public class DefaultIdentitySupplier {
    private final CanSendFrom canSendFrom;
    private final UsersRepository usersRepository;

    public List<Identity> listIdentities(Username username) {
        return ((IterableOnceOps)StreamConverters$.MODULE$.StreamHasToScala(this.canSendFrom.allValidFromAddressesForUser(username)).toScala(IterableFactory$.MODULE$.toFactory((IterableFactory)package$.MODULE$.LazyList()), StreamExtensions.AccumulatorFactoryInfo$.MODULE$.noAccumulatorFactoryInfo())).toList().flatMap((Function1 & Serializable)address -> this.from((MailAddress)address).map((Function1 & Serializable)id -> new Identity((IdentityId)id, address.asString(), (MailAddress)address, (Option<List<EmailAddress>>)None$.MODULE$, (Option<List<EmailAddress>>)None$.MODULE$, TextSignature$.MODULE$.DEFAULT(), HtmlSignature$.MODULE$.DEFAULT(), false)));
    }

    public boolean userCanSendFrom(Username username, MailAddress mailAddress) {
        return this.canSendFrom.userCanSendFrom(username, this.usersRepository.getUsername(mailAddress));
    }

    public boolean isServerSetIdentity(Username username, IdentityId id) {
        return this.listIdentities(username).map((Function1 & Serializable)x$6 -> x$6.id()).contains((Object)id);
    }

    private Option<IdentityId> from(MailAddress address) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> UUID.nameUUIDFromBytes(address.asString().getBytes(StandardCharsets.UTF_8))).toEither().toOption().map((Function1 & Serializable)x$7 -> new IdentityId((UUID)x$7));
    }

    @Inject
    public DefaultIdentitySupplier(CanSendFrom canSendFrom, UsersRepository usersRepository) {
        this.canSendFrom = canSendFrom;
        this.usersRepository = usersRepository;
    }
}

