/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.BindMarker;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.model.MailboxACL;
import reactor.core.publisher.Mono;

public class CassandraACLDAOV2 {
    private final CassandraAsyncExecutor executor;
    private final PreparedStatement insertRights;
    private final PreparedStatement removeRights;
    private final PreparedStatement replaceRights;
    private final PreparedStatement delete;
    private final PreparedStatement read;

    @Inject
    public CassandraACLDAOV2(Session session) {
        this.executor = new CassandraAsyncExecutor(session);
        this.insertRights = this.prepareInsertRights(session);
        this.removeRights = this.prepareRemoveRights(session);
        this.replaceRights = this.prepareReplaceRights(session);
        this.read = this.prepareRead(session);
        this.delete = this.prepareDelete(session);
    }

    private PreparedStatement prepareDelete(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.delete().from("aclv2").where(QueryBuilder.eq((String)"id", (Object)QueryBuilder.bindMarker((String)"id"))));
    }

    private PreparedStatement prepareInsertRights(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.update((String)"aclv2").with(QueryBuilder.addAll((String)"rights", (BindMarker)QueryBuilder.bindMarker((String)"rights"))).where(QueryBuilder.eq((String)"id", (Object)QueryBuilder.bindMarker((String)"id"))).and(QueryBuilder.eq((String)"key", (Object)QueryBuilder.bindMarker((String)"key"))));
    }

    private PreparedStatement prepareReplaceRights(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.update((String)"aclv2").with(QueryBuilder.set((String)"rights", (Object)QueryBuilder.bindMarker((String)"rights"))).where(QueryBuilder.eq((String)"id", (Object)QueryBuilder.bindMarker((String)"id"))).and(QueryBuilder.eq((String)"key", (Object)QueryBuilder.bindMarker((String)"key"))));
    }

    private PreparedStatement prepareRemoveRights(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.update((String)"aclv2").with(QueryBuilder.removeAll((String)"rights", (BindMarker)QueryBuilder.bindMarker((String)"rights"))).where(QueryBuilder.eq((String)"id", (Object)QueryBuilder.bindMarker((String)"id"))).and(QueryBuilder.eq((String)"key", (Object)QueryBuilder.bindMarker((String)"key"))));
    }

    private PreparedStatement prepareRead(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select().from("aclv2").where(QueryBuilder.eq((String)"id", (Object)QueryBuilder.bindMarker((String)"id"))));
    }

    public Mono<Void> delete(CassandraId cassandraId) {
        return this.executor.executeVoid((Statement)this.delete.bind().setUUID("id", cassandraId.asUuid()));
    }

    public Mono<MailboxACL> getACL(CassandraId cassandraId) {
        return this.executor.executeRows((Statement)this.read.bind().setUUID("id", cassandraId.asUuid())).map((Function)Throwing.function(row -> {
            MailboxACL.EntryKey entryKey = MailboxACL.EntryKey.deserialize((String)row.getString("key"));
            MailboxACL.Rfc4314Rights rights = row.getSet("rights", String.class).stream().map(Throwing.function(MailboxACL.Rfc4314Rights::deserialize)).reduce(MailboxACL.NO_RIGHTS, Throwing.binaryOperator(MailboxACL.Rfc4314Rights::union));
            return new MailboxACL((Map)ImmutableMap.of((Object)entryKey, (Object)rights));
        })).reduce((BiFunction)Throwing.biFunction(MailboxACL::union));
    }

    public Mono<Void> updateACL(CassandraId cassandraId, MailboxACL.ACLCommand command) {
        ImmutableSet<String> rightStrings = this.asStringSet(command.getRights());
        switch (command.getEditMode()) {
            case ADD: {
                return this.executor.executeVoid((Statement)this.insertRights.bind().setUUID("id", cassandraId.asUuid()).setString("key", command.getEntryKey().serialize()).setSet("rights", (Set)ImmutableSet.copyOf(rightStrings), String.class));
            }
            case REMOVE: {
                return this.executor.executeVoid((Statement)this.removeRights.bind().setUUID("id", cassandraId.asUuid()).setString("key", command.getEntryKey().serialize()).setSet("rights", (Set)ImmutableSet.copyOf(rightStrings), String.class));
            }
            case REPLACE: {
                return this.executor.executeVoid((Statement)this.replaceRights.bind().setUUID("id", cassandraId.asUuid()).setString("key", command.getEntryKey().serialize()).setSet("rights", rightStrings, String.class));
            }
        }
        throw new NotImplementedException(command.getEditMode() + "is not supported");
    }

    private ImmutableSet<String> asStringSet(MailboxACL.Rfc4314Rights rights) {
        return (ImmutableSet)rights.list().stream().map(MailboxACL.Right::asCharacter).map(String::valueOf).collect(ImmutableSet.toImmutableSet());
    }
}

