/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.impl;

import java.util.Iterator;
import java.util.LinkedList;
import org.apache.james.jspf.core.DNSLookupContinuation;
import org.apache.james.jspf.core.DNSService;
import org.apache.james.jspf.core.DNSServiceEnabled;
import org.apache.james.jspf.core.LogEnabled;
import org.apache.james.jspf.core.Logger;
import org.apache.james.jspf.core.MacroExpand;
import org.apache.james.jspf.core.MacroExpandEnabled;
import org.apache.james.jspf.core.SPF1Record;
import org.apache.james.jspf.core.SPF1Utils;
import org.apache.james.jspf.core.SPFCheckEnabled;
import org.apache.james.jspf.core.SPFChecker;
import org.apache.james.jspf.core.SPFCheckerExceptionCatcher;
import org.apache.james.jspf.core.SPFRecordParser;
import org.apache.james.jspf.core.SPFSession;
import org.apache.james.jspf.core.exceptions.NeutralException;
import org.apache.james.jspf.core.exceptions.NoneException;
import org.apache.james.jspf.core.exceptions.PermErrorException;
import org.apache.james.jspf.core.exceptions.SPFResultException;
import org.apache.james.jspf.core.exceptions.TempErrorException;
import org.apache.james.jspf.executor.FutureSPFResult;
import org.apache.james.jspf.executor.SPFExecutor;
import org.apache.james.jspf.executor.SPFResult;
import org.apache.james.jspf.executor.SynchronousSPFExecutor;
import org.apache.james.jspf.impl.DefaultTermsFactory;
import org.apache.james.jspf.parser.RFC4408SPF1Parser;
import org.apache.james.jspf.policies.InitialChecksPolicy;
import org.apache.james.jspf.policies.NeutralIfNotMatchPolicy;
import org.apache.james.jspf.policies.NoSPFRecordFoundPolicy;
import org.apache.james.jspf.policies.ParseRecordPolicy;
import org.apache.james.jspf.policies.Policy;
import org.apache.james.jspf.policies.PolicyPostFilter;
import org.apache.james.jspf.policies.SPFRetriever;
import org.apache.james.jspf.policies.SPFStrictCheckerRetriever;
import org.apache.james.jspf.policies.local.BestGuessPolicy;
import org.apache.james.jspf.policies.local.DefaultExplanationPolicy;
import org.apache.james.jspf.policies.local.FallbackPolicy;
import org.apache.james.jspf.policies.local.OverridePolicy;
import org.apache.james.jspf.policies.local.TrustedForwarderPolicy;
import org.apache.james.jspf.wiring.WiringServiceTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPF
implements SPFChecker {
    private DNSService dnsProbe;
    private SPFRecordParser parser;
    private Logger log;
    private String defaultExplanation = null;
    private boolean useBestGuess = false;
    private FallbackPolicy fallBack;
    private OverridePolicy override;
    private boolean useTrustedForwarder = false;
    private boolean mustEquals = false;
    private MacroExpand macroExpand;
    private SPFExecutor executor;

    public SPF(DNSService dnsProbe, Logger logger) {
        this.dnsProbe = dnsProbe;
        this.log = logger;
        WiringServiceTable wiringService = new WiringServiceTable();
        wiringService.put(LogEnabled.class, this.log);
        wiringService.put(DNSServiceEnabled.class, this.dnsProbe);
        this.macroExpand = new MacroExpand(logger.getChildLogger("macroExpand"), this.dnsProbe);
        wiringService.put(MacroExpandEnabled.class, this.macroExpand);
        this.parser = new RFC4408SPF1Parser(logger.getChildLogger("parser"), new DefaultTermsFactory(logger.getChildLogger("termsfactory"), wiringService));
        wiringService.put(SPFCheckEnabled.class, this);
        this.executor = new SynchronousSPFExecutor(this.log, dnsProbe);
    }

    public SPF(DNSService dnsProbe, SPFRecordParser parser, Logger logger, MacroExpand macroExpand, SPFExecutor executor) {
        this.dnsProbe = dnsProbe;
        this.parser = parser;
        this.log = logger;
        this.macroExpand = macroExpand;
        this.executor = executor;
    }

    public SPFResult checkSPF(String ipAddress, String mailFrom, String hostName) {
        SPFSession spfData = null;
        spfData = new SPFSession(mailFrom, hostName, ipAddress);
        DefaultSPFChecker resultHandler = new DefaultSPFChecker(this.log);
        spfData.pushChecker(resultHandler);
        spfData.pushChecker(this);
        FutureSPFResult ret = new FutureSPFResult(this.log);
        this.executor.execute(spfData, ret);
        return ret;
    }

    @Override
    public DNSLookupContinuation checkSPF(SPFSession spfData) throws PermErrorException, NoneException, TempErrorException, NeutralException {
        if (spfData.getCurrentResultExpanded() == null && spfData.getCurrentResult() == null) {
            PolicyChecker policyChecker = new PolicyChecker(this.getPolicies());
            SPFRecordChecker recordChecker = new SPFRecordChecker();
            spfData.pushChecker(recordChecker);
            spfData.pushChecker(policyChecker);
        }
        return null;
    }

    public LinkedList<SPFChecker> getPolicies() {
        LinkedList<SPFChecker> policies = new LinkedList<SPFChecker>();
        if (this.override != null) {
            policies.add(new SPFPolicyChecker(this.override));
        }
        policies.add(new InitialChecksPolicy());
        if (this.mustEquals) {
            policies.add(new SPFStrictCheckerRetriever());
        } else {
            policies.add(new SPFRetriever());
        }
        if (this.useBestGuess) {
            policies.add(new SPFPolicyPostFilterChecker(new BestGuessPolicy()));
        }
        policies.add(new SPFPolicyPostFilterChecker(new ParseRecordPolicy(this.parser)));
        if (this.fallBack != null) {
            policies.add(new SPFPolicyPostFilterChecker(this.fallBack));
        }
        policies.add(new SPFPolicyPostFilterChecker(new NoSPFRecordFoundPolicy()));
        if (this.useTrustedForwarder) {
            policies.add(new SPFPolicyPostFilterChecker(new TrustedForwarderPolicy(this.log)));
        }
        policies.add(new SPFPolicyPostFilterChecker(new NeutralIfNotMatchPolicy()));
        policies.add(new SPFPolicyPostFilterChecker(new DefaultExplanationPolicy(this.log, this.defaultExplanation, this.macroExpand)));
        return policies;
    }

    public synchronized void setTimeOut(int timeOut) {
        this.log.debug("TimeOut was set to: " + timeOut);
        this.dnsProbe.setTimeOut(timeOut);
    }

    public synchronized void setDefaultExplanation(String defaultExplanation) {
        this.defaultExplanation = defaultExplanation;
    }

    public synchronized void setUseBestGuess(boolean useBestGuess) {
        this.useBestGuess = useBestGuess;
    }

    public synchronized FallbackPolicy getFallbackPolicy() {
        if (this.fallBack == null) {
            this.fallBack = new FallbackPolicy(this.log.getChildLogger("fallbackpolicy"), this.parser);
        }
        return this.fallBack;
    }

    public synchronized void setUseTrustedForwarder(boolean useTrustedForwarder) {
        this.useTrustedForwarder = useTrustedForwarder;
    }

    public synchronized OverridePolicy getOverridePolicy() {
        if (this.override == null) {
            this.override = new OverridePolicy(this.log.getChildLogger("overridepolicy"), this.parser);
        }
        return this.override;
    }

    public synchronized void setSPFMustEqualsTXT(boolean mustEquals) {
        this.mustEquals = mustEquals;
    }

    private static final class DefaultSPFChecker
    implements SPFChecker,
    SPFCheckerExceptionCatcher {
        private Logger log;

        public DefaultSPFChecker(Logger log) {
            this.log = log;
        }

        public DNSLookupContinuation checkSPF(SPFSession spfData) throws PermErrorException, TempErrorException, NeutralException, NoneException {
            if (spfData.getCurrentResultExpanded() == null) {
                String resultChar = spfData.getCurrentResult() != null ? spfData.getCurrentResult() : "";
                String result = SPF1Utils.resultToName(resultChar);
                spfData.setCurrentResultExpanded(result);
            }
            return null;
        }

        public void onException(Exception exception, SPFSession session) throws PermErrorException, NoneException, TempErrorException, NeutralException {
            String result;
            if (exception instanceof SPFResultException) {
                result = ((SPFResultException)exception).getResult();
                if (!"neutral".equals(result)) {
                    this.log.warn(exception.getMessage(), exception);
                }
            } else {
                this.log.error(exception.getMessage(), exception);
                result = "neutral";
            }
            session.setCurrentResultExpanded(result);
        }
    }

    private static final class SPFPolicyPostFilterChecker
    implements SPFChecker {
        private PolicyPostFilter policy;

        public SPFPolicyPostFilterChecker(PolicyPostFilter policy) {
            this.policy = policy;
        }

        public DNSLookupContinuation checkSPF(SPFSession spfData) throws PermErrorException, TempErrorException, NeutralException, NoneException {
            SPF1Record res = (SPF1Record)spfData.getAttribute("SPF.SPF1Record");
            res = this.policy.getSPFRecord(spfData.getCurrentDomain(), res);
            spfData.setAttribute("SPF.SPF1Record", res);
            return null;
        }

        public String toString() {
            return "PFC:" + this.policy.toString();
        }
    }

    private static final class SPFPolicyChecker
    implements SPFChecker {
        private Policy policy;

        public SPFPolicyChecker(Policy policy) {
            this.policy = policy;
        }

        public DNSLookupContinuation checkSPF(SPFSession spfData) throws PermErrorException, TempErrorException, NeutralException, NoneException {
            SPF1Record res = (SPF1Record)spfData.getAttribute("SPF.SPF1Record");
            if (res == null) {
                res = this.policy.getSPFRecord(spfData.getCurrentDomain());
                spfData.setAttribute("SPF.SPF1Record", res);
            }
            return null;
        }

        public String toString() {
            return "PC:" + this.policy.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PolicyChecker
    implements SPFChecker {
        private LinkedList<SPFChecker> policies;

        public PolicyChecker(LinkedList<SPFChecker> policies) {
            this.policies = policies;
        }

        @Override
        public DNSLookupContinuation checkSPF(SPFSession spfData) throws PermErrorException, TempErrorException, NeutralException, NoneException {
            while (this.policies.size() > 0) {
                SPFChecker removeLast = this.policies.removeLast();
                spfData.pushChecker(removeLast);
            }
            return null;
        }
    }

    private static final class SPFRecordChecker
    implements SPFChecker {
        private SPFRecordChecker() {
        }

        public DNSLookupContinuation checkSPF(SPFSession spfData) throws PermErrorException, TempErrorException, NeutralException, NoneException {
            SPF1Record spfRecord = (SPF1Record)spfData.getAttribute("SPF.SPF1Record");
            spfData.removeAttribute("SPF.SPF1Record");
            LinkedList<SPFChecker> policyCheckers = new LinkedList<SPFChecker>();
            Iterator<SPFChecker> i = spfRecord.iterator();
            while (i.hasNext()) {
                SPFChecker checker = i.next();
                policyCheckers.add(checker);
            }
            while (policyCheckers.size() > 0) {
                SPFChecker removeLast = (SPFChecker)policyCheckers.removeLast();
                spfData.pushChecker(removeLast);
            }
            return null;
        }
    }
}

