/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.impl;

import java.util.List;
import org.apache.james.jspf.core.DNSRequest;
import org.apache.james.jspf.core.exceptions.TimeoutException;
import org.apache.james.jspf.executor.DNSAsynchLookupService;
import org.apache.james.jspf.executor.IResponse;
import org.apache.james.jspf.executor.IResponseQueue;
import org.apache.james.jspf.impl.DNSServiceXBillImpl;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;
import uk.nominet.dnsjnio.ExtendedNonblockingResolver;
import uk.nominet.dnsjnio.LookupAsynch;
import uk.nominet.dnsjnio.NonblockingResolver;

public class DNSJnioAsynchService
implements DNSAsynchLookupService {
    private ExtendedNonblockingResolver resolver;

    public DNSJnioAsynchService(ExtendedNonblockingResolver resolver) {
        this.resolver = resolver;
        LookupAsynch.setDefaultResolver((ExtendedNonblockingResolver)resolver);
    }

    public synchronized void setTimeout(int timeout) {
        NonblockingResolver[] res = this.resolver.getResolvers();
        for (int i = 0; i < res.length; ++i) {
            res[i].setTimeout(timeout);
        }
    }

    public void getRecordsAsynch(DNSRequest request, int id, IResponseQueue responsePool) {
        try {
            Message message = this.makeQuery(request, id);
            LookupAsynch la = new LookupAsynch(message.getQuestion().getName(), message.getQuestion().getType());
            la.runAsynch(new Runnable(){
                private IResponseQueue responsePool;
                private Integer id;
                private LookupAsynch lookup;

                public void run() {
                    this.responsePool.insertResponse(new IResponse(){

                        @Override
                        public Exception getException() {
                            if (lookup.getResult() == 2) {
                                return new TimeoutException(lookup.getErrorString());
                            }
                            return null;
                        }

                        @Override
                        public Object getId() {
                            return id;
                        }

                        @Override
                        public List<String> getValue() {
                            return DNSServiceXBillImpl.convertRecordsToList(lookup.getAnswers());
                        }
                    });
                }

                public Runnable setResponsePool(LookupAsynch la, IResponseQueue responsePool, Integer integer) {
                    this.lookup = la;
                    this.responsePool = responsePool;
                    this.id = integer;
                    return this;
                }
            }.setResponsePool(la, responsePool, new Integer(id)));
        }
        catch (TextParseException e) {
            e.printStackTrace();
        }
    }

    private Message makeQuery(DNSRequest request, int id) throws TextParseException {
        int type;
        Name name = Name.fromString((String)request.getHostname(), (Name)Name.root);
        switch (request.getRecordType()) {
            case 1: {
                type = 1;
                break;
            }
            case 2: {
                type = 28;
                break;
            }
            case 3: {
                type = 15;
                break;
            }
            case 4: {
                type = 12;
                break;
            }
            case 6: {
                type = 99;
                break;
            }
            case 5: {
                type = 16;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown query type: " + request.getRecordType());
            }
        }
        Record question = Record.newRecord((Name)name, (int)type, (int)255);
        Message query = Message.newQuery((Record)question);
        query.getHeader().setID(id);
        return query;
    }
}

