/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.james.GuiceJamesServer;
import org.apache.james.server.core.configuration.Configuration;

public class TemporaryJamesServer {
    private static final List<String> CONFIGURATION_FILE_NAMES = ImmutableList.of((Object)"dnsservice.xml", (Object)"domainlist.xml", (Object)"imapserver.xml", (Object)"keystore", (Object)"listeners.xml", (Object)"lmtpserver.xml", (Object)"mailetcontainer.xml", (Object)"mailrepositorystore.xml", (Object)"managesieveserver.xml", (Object)"pop3server.xml", (Object)"smtpserver.xml", (Object)"usersrepository.xml", (Object[])new String[0]);
    private final Configuration configuration;
    private final File configurationFolder;
    private final List<String> configurationFileNames;
    private GuiceJamesServer jamesServer;

    public TemporaryJamesServer(File workingDir) {
        this(workingDir, CONFIGURATION_FILE_NAMES);
    }

    public TemporaryJamesServer(File workingDir, List<String> configurationFileNames) {
        this.configurationFileNames = configurationFileNames;
        Configuration.Basic configuration = Configuration.builder().workingDirectory(workingDir).build();
        this.configurationFolder = workingDir.toPath().resolve("conf").toFile();
        if (!this.configurationFolder.exists()) {
            this.configurationFolder.mkdir();
        }
        this.copyResources(Paths.get(this.configurationFolder.getAbsolutePath(), new String[0]));
        this.configuration = configuration;
    }

    public GuiceJamesServer getJamesServer() {
        if (this.jamesServer == null) {
            this.jamesServer = GuiceJamesServer.forConfiguration(this.configuration);
        }
        return this.jamesServer;
    }

    public void appendConfigurationFile(String configurationData, String configurationFileName) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(Paths.get(this.configurationFolder.getAbsolutePath(), configurationFileName).toFile());){
            IOUtils.write((String)configurationData, (OutputStream)outputStream, (Charset)StandardCharsets.UTF_8);
        }
    }

    private void copyResources(Path resourcesFolder) {
        this.configurationFileNames.forEach(resourceName -> TemporaryJamesServer.copyResource(resourcesFolder, resourceName));
    }

    public static void copyResource(Path resourcesFolder, String resourceName) {
        block14: {
            Path resolvedResource = resourcesFolder.resolve(resourceName);
            try (FileOutputStream outputStream = new FileOutputStream(resolvedResource.toFile());){
                URL resource = ClassLoader.getSystemClassLoader().getResource(resourceName);
                if (resource != null) {
                    try (InputStream stream = resource.openStream();){
                        stream.transferTo(outputStream);
                        break block14;
                    }
                }
                throw new RuntimeException("Failed to load configuration resource " + resourceName);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

