/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.stream;

import junit.framework.TestCase;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.stream.DefaultFieldBuilder;
import org.apache.james.mime4j.stream.RawField;
import org.apache.james.mime4j.util.ByteArrayBuffer;
import org.apache.james.mime4j.util.ByteSequence;
import org.apache.james.mime4j.util.RecycledByteArrayBuffer;

public class DefaultFieldBuilderTest
extends TestCase {
    static ByteArrayBuffer line(String line) throws Exception {
        ByteArrayBuffer buf = new ByteArrayBuffer(line.length());
        byte[] b = line.getBytes("US-ASCII");
        buf.append(b, 0, b.length);
        return buf;
    }

    public void testBasics() throws Exception {
        DefaultFieldBuilder builder = new DefaultFieldBuilder(0);
        builder.reset();
        builder.append(DefaultFieldBuilderTest.line("raw:   stuff;\r\n"));
        builder.append(DefaultFieldBuilderTest.line("   more stuff;\r\n"));
        builder.append(DefaultFieldBuilderTest.line("   a lot more stuff\r\n"));
        RecycledByteArrayBuffer buf = builder.getRaw();
        DefaultFieldBuilderTest.assertNotNull((Object)buf);
        DefaultFieldBuilderTest.assertEquals((String)"raw:   stuff;\r\n   more stuff;\r\n   a lot more stuff\r\n", (String)new String(buf.toByteArray(), "US-ASCII"));
        RawField field = builder.build();
        DefaultFieldBuilderTest.assertNotNull((Object)field);
        DefaultFieldBuilderTest.assertEquals((String)"raw", (String)field.getName());
        DefaultFieldBuilderTest.assertEquals((String)"  stuff;   more stuff;   a lot more stuff", (String)field.getBody());
        ByteSequence raw = field.getRaw();
        DefaultFieldBuilderTest.assertNotNull((Object)raw);
        DefaultFieldBuilderTest.assertEquals((String)"raw:   stuff;\r\n   more stuff;\r\n   a lot more stuff", (String)new String(raw.toByteArray(), "US-ASCII"));
    }

    public void testObsoleteSyntax() throws Exception {
        DefaultFieldBuilder builder = new DefaultFieldBuilder(0);
        builder.reset();
        builder.append(DefaultFieldBuilderTest.line("raw  : stuff;\r\n"));
        builder.append(DefaultFieldBuilderTest.line("   more stuff;\r\n"));
        builder.append(DefaultFieldBuilderTest.line("   a lot more stuff\r\n"));
        RecycledByteArrayBuffer buf = builder.getRaw();
        DefaultFieldBuilderTest.assertNotNull((Object)buf);
        DefaultFieldBuilderTest.assertEquals((String)"raw  : stuff;\r\n   more stuff;\r\n   a lot more stuff\r\n", (String)new String(buf.toByteArray(), "US-ASCII"));
        RawField field = builder.build();
        DefaultFieldBuilderTest.assertNotNull((Object)field);
        DefaultFieldBuilderTest.assertEquals((String)"raw", (String)field.getName());
        DefaultFieldBuilderTest.assertEquals((String)"stuff;   more stuff;   a lot more stuff", (String)field.getBody());
        ByteSequence raw = field.getRaw();
        DefaultFieldBuilderTest.assertNotNull((Object)raw);
        DefaultFieldBuilderTest.assertEquals((String)"raw  : stuff;\r\n   more stuff;\r\n   a lot more stuff", (String)new String(raw.toByteArray(), "US-ASCII"));
    }

    public void testNoTrailingCRLF() throws Exception {
        DefaultFieldBuilder builder = new DefaultFieldBuilder(0);
        builder.reset();
        builder.append(DefaultFieldBuilderTest.line("raw:   stuff;\r\n"));
        builder.append(DefaultFieldBuilderTest.line("   more stuff;\r\n"));
        builder.append(DefaultFieldBuilderTest.line("   a lot more stuff"));
        RecycledByteArrayBuffer buf = builder.getRaw();
        DefaultFieldBuilderTest.assertNotNull((Object)buf);
        DefaultFieldBuilderTest.assertEquals((String)"raw:   stuff;\r\n   more stuff;\r\n   a lot more stuff", (String)new String(buf.toByteArray(), "US-ASCII"));
        RawField field = builder.build();
        DefaultFieldBuilderTest.assertNotNull((Object)field);
        DefaultFieldBuilderTest.assertEquals((String)"raw", (String)field.getName());
        DefaultFieldBuilderTest.assertEquals((String)"  stuff;   more stuff;   a lot more stuff", (String)field.getBody());
        ByteSequence raw = field.getRaw();
        DefaultFieldBuilderTest.assertNotNull((Object)raw);
        DefaultFieldBuilderTest.assertEquals((String)"raw:   stuff;\r\n   more stuff;\r\n   a lot more stuff", (String)new String(raw.toByteArray(), "US-ASCII"));
    }

    public void testIllegalCharsInName() throws Exception {
        DefaultFieldBuilder builder = new DefaultFieldBuilder(0);
        builder.reset();
        builder.append(DefaultFieldBuilderTest.line("raw stuff: some stuff\r\n"));
        try {
            builder.build();
            DefaultFieldBuilderTest.fail((String)"MimeException should have been thrown");
        }
        catch (MimeException mimeException) {
            // empty catch block
        }
    }

    public void testReset() throws Exception {
        DefaultFieldBuilder builder = new DefaultFieldBuilder(0);
        builder.reset();
        builder.append(DefaultFieldBuilderTest.line("raw: some stuff\r\n"));
        RecycledByteArrayBuffer buf = builder.getRaw();
        DefaultFieldBuilderTest.assertNotNull((Object)buf);
        DefaultFieldBuilderTest.assertEquals((String)"raw: some stuff\r\n", (String)new String(buf.toByteArray(), "US-ASCII"));
        builder.reset();
        buf = builder.getRaw();
        DefaultFieldBuilderTest.assertTrue((boolean)buf.isEmpty());
        try {
            builder.build();
            DefaultFieldBuilderTest.fail((String)"MimeException should have been thrown");
        }
        catch (MimeException mimeException) {
            // empty catch block
        }
    }

    public void testTooLong() throws Exception {
        DefaultFieldBuilder builder = new DefaultFieldBuilder(20);
        builder.reset();
        builder.append(DefaultFieldBuilderTest.line("raw: some stuff\r\n"));
        try {
            builder.append(DefaultFieldBuilderTest.line("toooooooooooooooooooooooooooooooooooooons of stuff\r\n"));
            DefaultFieldBuilderTest.fail((String)"MimeException should have been thrown");
        }
        catch (MimeException mimeException) {
            // empty catch block
        }
    }
}

