/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.parser;

import org.apache.james.jdkim.parser.DKIMQuotedPrintable;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class DKIMQuotedPrintableTest {
    @Test
    public void testQPDecode() {
        Assert.assertEquals((Object)"", (Object)DKIMQuotedPrintable.dkimQuotedPrintableDecode((CharSequence)""));
        Assert.assertEquals((Object)"@", (Object)DKIMQuotedPrintable.dkimQuotedPrintableDecode((CharSequence)"=40"));
        Assert.assertEquals((Object)"\r\n", (Object)DKIMQuotedPrintable.dkimQuotedPrintableDecode((CharSequence)"=0D=0A"));
        Assert.assertEquals((Object)"\u0000CIAO\u0000", (Object)DKIMQuotedPrintable.dkimQuotedPrintableDecode((CharSequence)"=00CIAO=00"));
        Assert.assertEquals((Object)"thisisatest", (Object)DKIMQuotedPrintable.dkimQuotedPrintableDecode((CharSequence)"this\r\n\tis\r\n a\r\n  \t test"));
    }

    @Test
    public void testQPWhiteSpaces() {
        Assert.assertEquals((Object)"thisisatest", (Object)DKIMQuotedPrintable.dkimQuotedPrintableDecode((CharSequence)"this is a test"));
        Assert.assertEquals((Object)"thisisatest", (Object)DKIMQuotedPrintable.dkimQuotedPrintableDecode((CharSequence)"this\r\n is a test"));
    }

    @Test
    public void testQPInvalid() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DKIMQuotedPrintable.dkimQuotedPrintableDecode((CharSequence)"=")).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Invalid quoted printable termination");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DKIMQuotedPrintable.dkimQuotedPrintableDecode((CharSequence)"==")).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Invalid input sequence at");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DKIMQuotedPrintable.dkimQuotedPrintableDecode((CharSequence)"=2 3")).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Invalid input sequence at");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DKIMQuotedPrintable.dkimQuotedPrintableDecode((CharSequence)"=3")).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Invalid quoted printable termination");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DKIMQuotedPrintable.dkimQuotedPrintableDecode((CharSequence)"=3a")).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Invalid input sequence at");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DKIMQuotedPrintable.dkimQuotedPrintableDecode((CharSequence)"==20")).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Invalid input sequence at");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DKIMQuotedPrintable.dkimQuotedPrintableDecode((CharSequence)"=20=")).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Invalid quoted printable termination");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DKIMQuotedPrintable.dkimQuotedPrintableDecode((CharSequence)"=3x")).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Invalid input sequence at");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DKIMQuotedPrintable.dkimQuotedPrintableDecode((CharSequence)"this\r\nis a test")).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Unexpected LF not part of an FWS");
    }

    @Test
    public void test8bit() {
        Assert.assertEquals((Object)"smiling face \u00d8\u00de with heart eyes", (Object)DKIMQuotedPrintable.dkimQuotedPrintableDecode((CharSequence)"smiling=20face=20=D8=DE=20with=20heart=20eyes"));
    }
}

