<!--
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->

Developing
==========

<!-- MACRO{toc} -->

Latest development
------------------
The latest FileVault Package Maven Plugin source code is available at

   <https://github.com/apache/jackrabbit-filevault-package-maven-plugin>


Building FileVault Package Maven Plugin
------------------
You can build FileVault Package Maven Plugin using Maven:

    cd jackrabbit-filevault-package-maven-plugin
    mvn clean install

You need Maven 3.3.9 (or higher) with Java 11 (or higher) for the build.
For more instructions, please see the documentation at <https://jackrabbit.apache.org/building-jackrabbit.html>

Issue Tracker
-------------
Apache Jackrabbit FileVault uses Jira for tracking bug reports and requests for improvements, new features, 
and other changes.

The issue tracker is available at <https://issues.apache.org/jira/browse/JCRVLT> and is readable by everyone. 
A Jira account is needed to create new issues and to comment on existing issues. Use the
[registration form](https://issues.apache.org/jira/secure/Signup!default.jspa) to request an account if you 
do not already have one.

See the [Jackrabbit Issue Tracker Page](https://jackrabbit.apache.org/issue-tracker.html) for more information.


Mailing Lists
-------------
To get involved with the Apache Jackrabbit project, start by having a
look at our website and joining our mailing lists. For more details about
Jackrabbit mailing lists as well as links to list archives, please see:

* https://jackrabbit.apache.org/mailing-lists.html

Releasing
---------
See the extensive [Release Documentation](howto_release.html) on the steps
involved to release Jackrabbit FileVault.
