/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.read.TableDeviceSourceNode;
import org.apache.iotdb.db.schemaengine.schemaregion.attribute.update.DeviceAttributeCacheUpdater;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class TableDeviceFetchNode
extends TableDeviceSourceNode {
    private final List<Object[]> deviceIdList;
    private final List<IDeviceID> partitionKeyList;

    public TableDeviceFetchNode(PlanNodeId id, String database, String tableName, List<Object[]> deviceIdList, List<IDeviceID> partitionKeyList, List<ColumnHeader> columnHeaderList, TDataNodeLocation senderLocation) {
        super(id, database, tableName, columnHeaderList, senderLocation);
        this.deviceIdList = deviceIdList;
        this.partitionKeyList = partitionKeyList;
    }

    public void addDeviceId(Object[] deviceId) {
        this.deviceIdList.add(deviceId);
    }

    public List<Object[]> getDeviceIdList() {
        return this.deviceIdList;
    }

    public List<IDeviceID> getPartitionKeyList() {
        return this.partitionKeyList;
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.TABLE_DEVICE_FETCH;
    }

    @Override
    public PlanNode clone() {
        throw new UnsupportedOperationException("The TableDeviceFetchNode's clone() method shall not be called.");
    }

    public PlanNode cloneForDistribution() {
        return new TableDeviceFetchNode(this.id, this.database, this.tableName, new ArrayList<Object[]>(), null, this.columnHeaderList, this.senderLocation);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.TABLE_DEVICE_FETCH.serialize(byteBuffer);
        ReadWriteIOUtils.write((String)this.database, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((String)this.tableName, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.deviceIdList.size(), (ByteBuffer)byteBuffer);
        for (Object[] deviceId : this.deviceIdList) {
            ReadWriteIOUtils.write((int)deviceId.length, (ByteBuffer)byteBuffer);
            for (Object idValue : deviceId) {
                ReadWriteIOUtils.writeObject((Object)idValue, (ByteBuffer)byteBuffer);
            }
        }
        ReadWriteIOUtils.write((int)this.columnHeaderList.size(), (ByteBuffer)byteBuffer);
        for (ColumnHeader columnHeader : this.columnHeaderList) {
            columnHeader.serialize(byteBuffer);
        }
        if (Objects.nonNull(this.senderLocation)) {
            ReadWriteIOUtils.write((Boolean)true, (ByteBuffer)byteBuffer);
            DeviceAttributeCacheUpdater.serializeNodeLocation4AttributeUpdate(this.senderLocation, byteBuffer);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (ByteBuffer)byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.TABLE_DEVICE_FETCH.serialize(stream);
        ReadWriteIOUtils.write((String)this.database, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.tableName, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.deviceIdList.size(), (OutputStream)stream);
        for (Object[] deviceId : this.deviceIdList) {
            ReadWriteIOUtils.write((int)deviceId.length, (OutputStream)stream);
            for (Object idValue : deviceId) {
                ReadWriteIOUtils.writeObject((Object)idValue, (DataOutputStream)stream);
            }
        }
        ReadWriteIOUtils.write((int)this.columnHeaderList.size(), (OutputStream)stream);
        for (ColumnHeader columnHeader : this.columnHeaderList) {
            columnHeader.serialize(stream);
        }
        if (Objects.nonNull(this.senderLocation)) {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
            DeviceAttributeCacheUpdater.serializeNodeLocation4AttributeUpdate(this.senderLocation, stream);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
        }
    }

    public static TableDeviceFetchNode deserialize(ByteBuffer buffer) {
        String database = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        String tableName = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        ArrayList<Object[]> deviceIdList = new ArrayList<Object[]>(size);
        for (int i = 0; i < size; ++i) {
            int length = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
            String[] nodes = new String[length];
            for (int j = 0; j < length; ++j) {
                nodes[j] = ReadWriteIOUtils.readObject((ByteBuffer)buffer);
            }
            deviceIdList.add(nodes);
        }
        size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        ArrayList<ColumnHeader> columnHeaderList = new ArrayList<ColumnHeader>(size);
        for (int i = 0; i < size; ++i) {
            columnHeaderList.add(ColumnHeader.deserialize((ByteBuffer)buffer));
        }
        TDataNodeLocation senderLocation = null;
        if (ReadWriteIOUtils.readBool((ByteBuffer)buffer)) {
            senderLocation = DeviceAttributeCacheUpdater.deserializeNodeLocationForAttributeUpdate(buffer);
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(buffer);
        return new TableDeviceFetchNode(planNodeId, database, tableName, deviceIdList, null, columnHeaderList, senderLocation);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitTableDeviceFetch(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TableDeviceFetchNode)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TableDeviceFetchNode that = (TableDeviceFetchNode)o;
        return Objects.equals(this.database, that.database) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.deviceIdList, that.deviceIdList) && Objects.equals(this.columnHeaderList, that.columnHeaderList) && Objects.equals(this.schemaRegionReplicaSet, that.schemaRegionReplicaSet);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.database, this.tableName, this.deviceIdList, this.columnHeaderList, this.schemaRegionReplicaSet);
    }
}

