/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar;

import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.UnaryColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;

public class StartsWithColumnTransformer
extends UnaryColumnTransformer {
    private final byte[] prefix;

    public StartsWithColumnTransformer(Type returnType, ColumnTransformer childColumnTransformer, String prefixStr) {
        super(returnType, childColumnTransformer);
        this.prefix = prefixStr.getBytes();
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (!column.isNull(i)) {
                byte[] currentValue = column.getBinary(i).getValues();
                columnBuilder.writeBoolean(StartsWithColumnTransformer.equalCompare(currentValue, this.prefix, 0));
                continue;
            }
            columnBuilder.appendNull();
        }
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder, boolean[] selection) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (selection[i] && !column.isNull(i)) {
                byte[] currentValue = column.getBinary(i).getValues();
                columnBuilder.writeBoolean(StartsWithColumnTransformer.equalCompare(currentValue, this.prefix, 0));
                continue;
            }
            columnBuilder.appendNull();
        }
    }

    public static boolean equalCompare(byte[] value, byte[] pattern, int offset) {
        if (value.length < pattern.length) {
            return false;
        }
        for (int i = 0; i < pattern.length && i + offset < value.length; ++i) {
            if (value[i + offset] == pattern[i]) continue;
            return false;
        }
        return true;
    }
}

