/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.statistics.StatisticsManager;
import org.apache.tsfile.enums.TSDataType;

public class OperatorGeneratorUtil {
    public static long calculateStatementSizePerLine(List<TSDataType> dataTypeList) {
        long maxStatementSize = 8L;
        for (TSDataType dataType : dataTypeList) {
            maxStatementSize += OperatorGeneratorUtil.getValueSizePerLine(dataType);
        }
        return maxStatementSize;
    }

    public static long calculateStatementSizePerLine(Map<PartialPath, Map<String, TSDataType>> targetPathToDataTypeMap) {
        long maxStatementSize = 8L;
        List dataTypes = targetPathToDataTypeMap.values().stream().flatMap(stringTSDataTypeMap -> stringTSDataTypeMap.values().stream()).collect(Collectors.toList());
        for (TSDataType dataType : dataTypes) {
            maxStatementSize += OperatorGeneratorUtil.getValueSizePerLine(dataType);
        }
        return maxStatementSize;
    }

    private static long getValueSizePerLine(TSDataType tsDataType) {
        switch (tsDataType) {
            case INT32: 
            case DATE: {
                return 4L;
            }
            case INT64: 
            case TIMESTAMP: {
                return 8L;
            }
            case FLOAT: {
                return 4L;
            }
            case DOUBLE: {
                return 8L;
            }
            case BOOLEAN: {
                return 1L;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                return StatisticsManager.getInstance().getMaxBinarySizeInBytes();
            }
        }
        throw new UnsupportedOperationException("Unknown data type: " + tsDataType);
    }
}

