/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.datastream;

import org.apache.ratis.conf.Parameters;
import org.apache.ratis.datastream.DataStreamFactory;
import org.apache.ratis.datastream.DataStreamType;
import org.apache.ratis.util.ReflectionUtils;

public enum SupportedDataStreamType implements DataStreamType
{
    DISABLED("org.apache.ratis.client.DisabledDataStreamClientFactory", "org.apache.ratis.server.DisabledDataStreamServerFactory"),
    NETTY("org.apache.ratis.netty.NettyDataStreamFactory");

    private static final Class<?>[] ARG_CLASSES;
    private final String clientFactoryClassName;
    private final String serverFactoryClassName;

    public static SupportedDataStreamType valueOfIgnoreCase(String s) {
        return SupportedDataStreamType.valueOf(s.toUpperCase());
    }

    private SupportedDataStreamType(String clientFactoryClassName, String serverFactoryClassName) {
        this.clientFactoryClassName = clientFactoryClassName;
        this.serverFactoryClassName = serverFactoryClassName;
    }

    private SupportedDataStreamType(String factoryClassName) {
        this(factoryClassName, factoryClassName);
    }

    @Override
    public DataStreamFactory newClientFactory(Parameters parameters) {
        Class<DataStreamFactory> clazz = ReflectionUtils.getClass(this.clientFactoryClassName, DataStreamFactory.class);
        return ReflectionUtils.newInstance(clazz, ARG_CLASSES, parameters);
    }

    @Override
    public DataStreamFactory newServerFactory(Parameters parameters) {
        Class<DataStreamFactory> clazz = ReflectionUtils.getClass(this.serverFactoryClassName, DataStreamFactory.class);
        return ReflectionUtils.newInstance(clazz, ARG_CLASSES, parameters);
    }

    static {
        ARG_CLASSES = new Class[]{Parameters.class};
    }
}

