/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.path.AlignedFullPath;
import org.apache.iotdb.commons.path.IFullPath;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.schemaengine.schemaregion.utils.ResourceByPathUtils;
import org.apache.iotdb.db.storageengine.dataregion.memtable.AlignedReadOnlyMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.memtable.AlignedWritableMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.memtable.AlignedWritableMemChunkGroup;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IMemTable;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IWritableMemChunkGroup;
import org.apache.iotdb.db.storageengine.dataregion.memtable.ReadOnlyMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModEntry;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.utils.ModificationUtils;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.AbstractAlignedChunkMetadata;
import org.apache.tsfile.file.metadata.AbstractAlignedTimeSeriesMetadata;
import org.apache.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.tsfile.file.metadata.AlignedTimeSeriesMetadata;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.TableDeviceChunkMetadata;
import org.apache.tsfile.file.metadata.TableDeviceTimeSeriesMetadata;
import org.apache.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.VectorMeasurementSchema;
import org.apache.tsfile.write.writer.RestorableTsFileIOWriter;

class AlignedResourceByPathUtils
extends ResourceByPathUtils {
    AlignedFullPath alignedFullPath;

    public AlignedResourceByPathUtils(IFullPath fullPath) {
        this.alignedFullPath = (AlignedFullPath)fullPath;
    }

    public AbstractAlignedTimeSeriesMetadata generateTimeSeriesMetadata(List<ReadOnlyMemChunk> readOnlyMemChunk, List<IChunkMetadata> chunkMetadataList) {
        int i;
        AbstractAlignedChunkMetadata alignedChunkMetadata;
        TimeseriesMetadata timeTimeSeriesMetadata = new TimeseriesMetadata();
        timeTimeSeriesMetadata.setDataSizeOfChunkMetaDataList(-1);
        timeTimeSeriesMetadata.setMeasurementId("");
        timeTimeSeriesMetadata.setTsDataType(TSDataType.VECTOR);
        Statistics timeStatistics = Statistics.getStatsByType((TSDataType)timeTimeSeriesMetadata.getTsDataType());
        ArrayList<TimeseriesMetadata> valueTimeSeriesMetadataList = new ArrayList<TimeseriesMetadata>();
        for (IMeasurementSchema valueChunkMetadata : this.alignedFullPath.getSchemaList()) {
            TimeseriesMetadata valueMetadata = new TimeseriesMetadata();
            valueMetadata.setDataSizeOfChunkMetaDataList(-1);
            valueMetadata.setMeasurementId(valueChunkMetadata.getMeasurementName());
            valueMetadata.setTsDataType(valueChunkMetadata.getType());
            valueMetadata.setStatistics(Statistics.getStatsByType((TSDataType)valueChunkMetadata.getType()));
            valueTimeSeriesMetadataList.add(valueMetadata);
        }
        boolean[] exist = new boolean[this.alignedFullPath.getSchemaList().size()];
        boolean modified = false;
        boolean isTable = false;
        for (IChunkMetadata chunkMetadata : chunkMetadataList) {
            alignedChunkMetadata = (AbstractAlignedChunkMetadata)chunkMetadata;
            isTable = isTable || alignedChunkMetadata instanceof TableDeviceChunkMetadata;
            modified = modified || alignedChunkMetadata.isModified();
            timeStatistics.mergeStatistics(alignedChunkMetadata.getTimeChunkMetadata().getStatistics());
            for (i = 0; i < valueTimeSeriesMetadataList.size(); ++i) {
                if (alignedChunkMetadata.getValueChunkMetadataList().get(i) == null) continue;
                exist[i] = true;
                ((TimeseriesMetadata)valueTimeSeriesMetadataList.get(i)).getStatistics().mergeStatistics(((IChunkMetadata)alignedChunkMetadata.getValueChunkMetadataList().get(i)).getStatistics());
            }
        }
        for (ReadOnlyMemChunk memChunk : readOnlyMemChunk) {
            if (memChunk.isEmpty()) continue;
            memChunk.sortTvLists();
            memChunk.initChunkMetaFromTvLists();
            alignedChunkMetadata = (AbstractAlignedChunkMetadata)memChunk.getChunkMetaData();
            isTable = isTable || alignedChunkMetadata instanceof TableDeviceChunkMetadata;
            timeStatistics.mergeStatistics(alignedChunkMetadata.getTimeChunkMetadata().getStatistics());
            for (i = 0; i < valueTimeSeriesMetadataList.size(); ++i) {
                if (alignedChunkMetadata.getValueChunkMetadataList().get(i) == null) continue;
                exist[i] = true;
                ((TimeseriesMetadata)valueTimeSeriesMetadataList.get(i)).getStatistics().mergeStatistics(((IChunkMetadata)alignedChunkMetadata.getValueChunkMetadataList().get(i)).getStatistics());
            }
        }
        timeTimeSeriesMetadata.setStatistics(timeStatistics);
        timeTimeSeriesMetadata.setModified(modified);
        for (int i2 = 0; i2 < valueTimeSeriesMetadataList.size(); ++i2) {
            if (exist[i2]) continue;
            valueTimeSeriesMetadataList.set(i2, null);
        }
        return isTable ? new TableDeviceTimeSeriesMetadata(timeTimeSeriesMetadata, valueTimeSeriesMetadataList) : new AlignedTimeSeriesMetadata(timeTimeSeriesMetadata, valueTimeSeriesMetadataList);
    }

    @Override
    public ReadOnlyMemChunk getReadOnlyMemChunkFromMemTable(QueryContext context, IMemTable memTable, List<Pair<ModEntry, IMemTable>> modsToMemtable, long timeLowerBound, Filter globalTimeFilter) throws QueryProcessException {
        IDeviceID deviceID;
        Map<IDeviceID, IWritableMemChunkGroup> memTableMap = memTable.getMemTableMap();
        if (!memTableMap.containsKey(deviceID = this.alignedFullPath.getDeviceId())) {
            return null;
        }
        AlignedWritableMemChunk alignedMemChunk = ((AlignedWritableMemChunkGroup)memTableMap.get(deviceID)).getAlignedMemChunk();
        if (context.isIgnoreAllNullRows()) {
            boolean containsMeasurement = false;
            for (String measurement : this.alignedFullPath.getMeasurementList()) {
                if (!alignedMemChunk.containsMeasurement(measurement)) continue;
                containsMeasurement = true;
                break;
            }
            if (!containsMeasurement) {
                return null;
            }
        }
        Map<TVList, Integer> alignedTvListQueryMap = this.prepareTvListMapForQuery(context, alignedMemChunk, modsToMemtable == null, globalTimeFilter);
        List<Integer> columnIndexList = alignedMemChunk.buildColumnIndexList(this.alignedFullPath.getSchemaList());
        List<TimeRange> timeColumnDeletion = null;
        List<List<TimeRange>> valueColumnsDeletionList = null;
        if (modsToMemtable != null) {
            timeColumnDeletion = ModificationUtils.constructDeletionList(this.alignedFullPath.getDeviceId(), Collections.singletonList(""), memTable, modsToMemtable, timeLowerBound).get(0);
            valueColumnsDeletionList = ModificationUtils.constructDeletionList(this.alignedFullPath.getDeviceId(), this.alignedFullPath.getMeasurementList(), memTable, modsToMemtable, timeLowerBound);
        }
        return new AlignedReadOnlyMemChunk(context, columnIndexList, (IMeasurementSchema)this.getMeasurementSchema(), alignedTvListQueryMap, timeColumnDeletion, valueColumnsDeletionList);
    }

    public VectorMeasurementSchema getMeasurementSchema() {
        List measurementList = this.alignedFullPath.getMeasurementList();
        TSDataType[] types = new TSDataType[measurementList.size()];
        TSEncoding[] encodings = new TSEncoding[measurementList.size()];
        for (int i = 0; i < measurementList.size(); ++i) {
            types[i] = ((IMeasurementSchema)this.alignedFullPath.getSchemaList().get(i)).getType();
            encodings[i] = ((IMeasurementSchema)this.alignedFullPath.getSchemaList().get(i)).getEncodingType();
        }
        String[] array = new String[measurementList.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (String)measurementList.get(i);
        }
        return new VectorMeasurementSchema("", array, types, encodings, CompressionType.UNCOMPRESSED);
    }

    @Override
    public List<IChunkMetadata> getVisibleMetadataListFromWriter(RestorableTsFileIOWriter writer, TsFileResource tsFileResource, QueryContext context, long timeLowerBound) {
        int i;
        ArrayList<Object> chunkMetadataList = new ArrayList<Object>();
        List timeChunkMetadataList = writer.getVisibleMetadataList(this.alignedFullPath.getDeviceId(), "", TSDataType.VECTOR);
        ArrayList<List> valueChunkMetadataList = new ArrayList<List>();
        for (i = 0; i < this.alignedFullPath.getMeasurementList().size(); ++i) {
            valueChunkMetadataList.add(writer.getVisibleMetadataList(this.alignedFullPath.getDeviceId(), (String)this.alignedFullPath.getMeasurementList().get(i), ((IMeasurementSchema)this.alignedFullPath.getSchemaList().get(i)).getType()));
        }
        for (i = 0; i < timeChunkMetadataList.size(); ++i) {
            if (this.alignedFullPath.getMeasurementList().isEmpty()) {
                chunkMetadataList.add(context.isIgnoreAllNullRows() ? new AlignedChunkMetadata((IChunkMetadata)timeChunkMetadataList.get(i), Collections.emptyList()) : new TableDeviceChunkMetadata((IChunkMetadata)timeChunkMetadataList.get(i), Collections.emptyList()));
                continue;
            }
            ArrayList<IChunkMetadata> valueChunkMetadata = new ArrayList<IChunkMetadata>();
            boolean exits = false;
            for (List chunkMetadata : valueChunkMetadataList) {
                boolean currentExist = i < chunkMetadata.size() && ((ChunkMetadata)chunkMetadata.get(i)).getNumOfPoints() > 0L;
                exits = exits || currentExist;
                valueChunkMetadata.add(currentExist ? (IChunkMetadata)chunkMetadata.get(i) : null);
            }
            if (context.isIgnoreAllNullRows() && !exits) continue;
            chunkMetadataList.add(context.isIgnoreAllNullRows() ? new AlignedChunkMetadata((IChunkMetadata)timeChunkMetadataList.get(i), valueChunkMetadata) : new TableDeviceChunkMetadata((IChunkMetadata)timeChunkMetadataList.get(i), valueChunkMetadata));
        }
        List<ModEntry> timeColumnModifications = context.getPathModifications(tsFileResource, this.alignedFullPath.getDeviceId(), "");
        List<List<ModEntry>> valueColumnsModifications = context.getPathModifications(tsFileResource, this.alignedFullPath.getDeviceId(), this.alignedFullPath.getMeasurementList());
        ModificationUtils.modifyAlignedChunkMetaData(chunkMetadataList, timeColumnModifications, valueColumnsModifications, context.isIgnoreAllNullRows());
        chunkMetadataList.removeIf(x -> x.getEndTime() < timeLowerBound);
        return new ArrayList<IChunkMetadata>(chunkMetadataList);
    }
}

