/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.approximate;

import java.util.Objects;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.approximate.SpaceSaving;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.SpaceSavingBigArray;
import org.apache.tsfile.utils.RamUsageEstimator;

public class SpaceSavingStateFactory {
    public static <T> SingleSpaceSavingState<T> createSingleState() {
        return new SingleSpaceSavingState();
    }

    public static <T> GroupedSpaceSavingState<T> createGroupedState() {
        return new GroupedSpaceSavingState();
    }

    public static class SingleSpaceSavingState<T> {
        private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(SingleSpaceSavingState.class);
        private SpaceSaving<T> spaceSaving;

        public SpaceSaving<T> getSpaceSaving() {
            return this.spaceSaving;
        }

        public void setSpaceSaving(SpaceSaving<T> value) {
            this.spaceSaving = value;
        }

        public long getEstimatedSize() {
            return this.spaceSaving == null ? INSTANCE_SIZE + SpaceSaving.getDefaultEstimatedSize() : INSTANCE_SIZE + this.spaceSaving.getEstimatedSize();
        }

        public void merge(SpaceSaving<T> other) {
            if (this.spaceSaving == null) {
                this.setSpaceSaving(other);
            } else {
                this.spaceSaving.merge(other);
            }
        }
    }

    public static class GroupedSpaceSavingState<T> {
        private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(GroupedSpaceSavingState.class);
        private SpaceSavingBigArray<T> spaceSavings = new SpaceSavingBigArray();

        public SpaceSavingBigArray<T> getSpaceSavings() {
            return this.spaceSavings;
        }

        public void setSpaceSavings(SpaceSavingBigArray<T> value) {
            Objects.requireNonNull(value, "value is null");
            this.spaceSavings = value;
        }

        public long getEstimatedSize() {
            return INSTANCE_SIZE + this.spaceSavings.sizeOf();
        }

        public void merge(int groupId, SpaceSaving<T> spaceSaving) {
            SpaceSaving<T> existingSpaceSaving = this.spaceSavings.get(groupId, spaceSaving);
            if (!existingSpaceSaving.equals(spaceSaving)) {
                existingSpaceSaving.merge(spaceSaving);
            }
        }

        public boolean isEmpty() {
            return this.spaceSavings.isEmpty();
        }
    }
}

