/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tsfile.parser.table;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TablePattern;
import org.apache.iotdb.db.pipe.event.common.PipeInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.parser.TsFileInsertionEventParser;
import org.apache.iotdb.db.pipe.event.common.tsfile.parser.table.TsFileInsertionEventTableParserTabletIterator;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryBlock;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.QualifiedObjectName;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.write.record.Tablet;

public class TsFileInsertionEventTableParser
extends TsFileInsertionEventParser {
    private final long startTime;
    private final long endTime;
    private final TablePattern tablePattern;
    private final String userName;
    private final PipeMemoryBlock allocatedMemoryBlockForBatchData;
    private final PipeMemoryBlock allocatedMemoryBlockForChunk;
    private final PipeMemoryBlock allocatedMemoryBlockForChunkMeta;
    private final PipeMemoryBlock allocatedMemoryBlockForTableSchemas;

    public TsFileInsertionEventTableParser(String pipeName, long creationTime, File tsFile, TablePattern pattern, long startTime, long endTime, PipeTaskMeta pipeTaskMeta, String userName, PipeInsertionEvent sourceEvent) throws IOException {
        super(pipeName, creationTime, null, pattern, startTime, endTime, pipeTaskMeta, sourceEvent);
        try {
            this.allocatedMemoryBlockForChunk = PipeDataNodeResourceManager.memory().forceAllocateForTabletWithRetry(0L);
            this.allocatedMemoryBlockForBatchData = PipeDataNodeResourceManager.memory().forceAllocateForTabletWithRetry(0L);
            this.allocatedMemoryBlockForChunkMeta = PipeDataNodeResourceManager.memory().forceAllocateForTabletWithRetry(0L);
            this.allocatedMemoryBlockForTableSchemas = PipeDataNodeResourceManager.memory().forceAllocateForTabletWithRetry(0L);
            this.startTime = startTime;
            this.endTime = endTime;
            this.tablePattern = pattern;
            this.userName = userName;
            this.tsFileSequenceReader = new TsFileSequenceReader(tsFile.getPath(), true, true);
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    public TsFileInsertionEventTableParser(File tsFile, TablePattern pattern, long startTime, long endTime, PipeTaskMeta pipeTaskMeta, String userName, PipeInsertionEvent sourceEvent) throws IOException {
        this(null, 0L, tsFile, pattern, startTime, endTime, pipeTaskMeta, userName, sourceEvent);
    }

    @Override
    public Iterable<TabletInsertionEvent> toTabletInsertionEvents() {
        return () -> new Iterator<TabletInsertionEvent>(){
            private TsFileInsertionEventTableParserTabletIterator tabletIterator;

            @Override
            public boolean hasNext() {
                try {
                    if (this.tabletIterator == null) {
                        this.tabletIterator = new TsFileInsertionEventTableParserTabletIterator(TsFileInsertionEventTableParser.this.tsFileSequenceReader, entry -> (Objects.isNull(TsFileInsertionEventTableParser.this.tablePattern) || TsFileInsertionEventTableParser.this.tablePattern.matchesTable((String)entry.getKey())) && this.hasTablePrivilege((String)entry.getKey()), TsFileInsertionEventTableParser.this.allocatedMemoryBlockForTablet, TsFileInsertionEventTableParser.this.allocatedMemoryBlockForBatchData, TsFileInsertionEventTableParser.this.allocatedMemoryBlockForChunk, TsFileInsertionEventTableParser.this.allocatedMemoryBlockForChunkMeta, TsFileInsertionEventTableParser.this.allocatedMemoryBlockForTableSchemas, TsFileInsertionEventTableParser.this.startTime, TsFileInsertionEventTableParser.this.endTime);
                    }
                    if (!this.tabletIterator.hasNext()) {
                        TsFileInsertionEventTableParser.this.close();
                        return false;
                    }
                    return true;
                }
                catch (Exception e) {
                    TsFileInsertionEventTableParser.this.close();
                    throw new PipeException("Error while parsing tsfile insertion event", (Throwable)e);
                }
            }

            private boolean hasTablePrivilege(String tableName) {
                return Objects.isNull(TsFileInsertionEventTableParser.this.userName) || Objects.isNull((Object)TsFileInsertionEventTableParser.this.sourceEvent) || Objects.isNull(TsFileInsertionEventTableParser.this.sourceEvent.getTableModelDatabaseName()) || Coordinator.getInstance().getAccessControl().checkCanSelectFromTable4Pipe(TsFileInsertionEventTableParser.this.userName, new QualifiedObjectName(TsFileInsertionEventTableParser.this.sourceEvent.getTableModelDatabaseName(), tableName));
            }

            @Override
            public TabletInsertionEvent next() {
                PipeRawTabletInsertionEvent next;
                if (!this.hasNext()) {
                    TsFileInsertionEventTableParser.this.close();
                    throw new NoSuchElementException();
                }
                Tablet tablet = this.tabletIterator.next();
                if (!this.hasNext()) {
                    next = TsFileInsertionEventTableParser.this.sourceEvent == null ? new PipeRawTabletInsertionEvent(Boolean.TRUE, null, null, null, tablet, true, null, 0L, TsFileInsertionEventTableParser.this.pipeTaskMeta, TsFileInsertionEventTableParser.this.sourceEvent, true) : new PipeRawTabletInsertionEvent(Boolean.TRUE, TsFileInsertionEventTableParser.this.sourceEvent.getSourceDatabaseNameFromDataRegion(), TsFileInsertionEventTableParser.this.sourceEvent.getRawTableModelDataBase(), TsFileInsertionEventTableParser.this.sourceEvent.getRawTreeModelDataBase(), tablet, true, TsFileInsertionEventTableParser.this.sourceEvent.getPipeName(), TsFileInsertionEventTableParser.this.sourceEvent.getCreationTime(), TsFileInsertionEventTableParser.this.pipeTaskMeta, TsFileInsertionEventTableParser.this.sourceEvent, true);
                    TsFileInsertionEventTableParser.this.close();
                } else {
                    next = TsFileInsertionEventTableParser.this.sourceEvent == null ? new PipeRawTabletInsertionEvent(Boolean.TRUE, null, null, null, tablet, true, null, 0L, TsFileInsertionEventTableParser.this.pipeTaskMeta, TsFileInsertionEventTableParser.this.sourceEvent, false) : new PipeRawTabletInsertionEvent(Boolean.TRUE, TsFileInsertionEventTableParser.this.sourceEvent.getSourceDatabaseNameFromDataRegion(), TsFileInsertionEventTableParser.this.sourceEvent.getRawTableModelDataBase(), TsFileInsertionEventTableParser.this.sourceEvent.getRawTreeModelDataBase(), tablet, true, TsFileInsertionEventTableParser.this.sourceEvent.getPipeName(), TsFileInsertionEventTableParser.this.sourceEvent.getCreationTime(), TsFileInsertionEventTableParser.this.pipeTaskMeta, TsFileInsertionEventTableParser.this.sourceEvent, false);
                }
                return next;
            }
        };
    }

    @Override
    public void close() {
        super.close();
        if (this.allocatedMemoryBlockForBatchData != null) {
            this.allocatedMemoryBlockForBatchData.close();
        }
        if (this.allocatedMemoryBlockForChunk != null) {
            this.allocatedMemoryBlockForChunk.close();
        }
        if (this.allocatedMemoryBlockForChunkMeta != null) {
            this.allocatedMemoryBlockForChunkMeta.close();
        }
        if (this.allocatedMemoryBlockForTableSchemas != null) {
            this.allocatedMemoryBlockForTableSchemas.close();
        }
    }
}

