/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ratis.RaftConfigKeys;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.datastream.SupportedDataStreamType;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.GroupInfoReply;
import org.apache.ratis.protocol.GroupInfoRequest;
import org.apache.ratis.protocol.GroupListReply;
import org.apache.ratis.protocol.GroupListRequest;
import org.apache.ratis.protocol.GroupManagementRequest;
import org.apache.ratis.protocol.LeaderElectionManagementRequest;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.protocol.SnapshotManagementRequest;
import org.apache.ratis.protocol.TransferLeadershipRequest;
import org.apache.ratis.protocol.exceptions.AlreadyClosedException;
import org.apache.ratis.protocol.exceptions.AlreadyExistsException;
import org.apache.ratis.protocol.exceptions.GroupMismatchException;
import org.apache.ratis.rpc.RpcFactory;
import org.apache.ratis.rpc.RpcType;
import org.apache.ratis.server.DataStreamServerRpc;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.RaftServerRpc;
import org.apache.ratis.server.ServerFactory;
import org.apache.ratis.server.impl.DataStreamServerImpl;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.util.ConcurrentUtils;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.JvmPauseMonitor;
import org.apache.ratis.util.LifeCycle;
import org.apache.ratis.util.MemoizedSupplier;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ProtoUtils;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;

class RaftServerProxy
implements RaftServer {
    private final RaftPeerId id;
    private final Supplier<RaftPeer> peerSupplier = JavaUtils.memoize(this::buildRaftPeer);
    private final RaftProperties properties;
    private final StateMachine.Registry stateMachineRegistry;
    private final LifeCycle lifeCycle;
    private final RaftServerRpc serverRpc;
    private final ServerFactory factory;
    private final DataStreamServerRpc dataStreamServerRpc;
    private final ImplMap impls = new ImplMap();
    private final MemoizedSupplier<ExecutorService> implExecutor;
    private final MemoizedSupplier<ExecutorService> executor;
    private final JvmPauseMonitor pauseMonitor;
    private final ThreadGroup threadGroup;

    RaftServerProxy(RaftPeerId id, StateMachine.Registry stateMachineRegistry, RaftProperties properties, Parameters parameters, ThreadGroup threadGroup) {
        this.properties = properties;
        this.stateMachineRegistry = stateMachineRegistry;
        RpcType rpcType = RaftConfigKeys.Rpc.type((RaftProperties)properties, arg_0 -> ((Logger)LOG).info(arg_0));
        this.factory = ServerFactory.cast((RpcFactory)rpcType.newFactory(parameters));
        this.serverRpc = this.factory.newRaftServerRpc((RaftServer)this);
        this.id = id != null ? id : RaftPeerId.valueOf((String)RaftServerProxy.getIdStringFrom(this.serverRpc));
        this.lifeCycle = new LifeCycle((Object)(this.id + "-" + JavaUtils.getClassSimpleName(this.getClass())));
        this.dataStreamServerRpc = new DataStreamServerImpl(this, parameters).getServerRpc();
        this.implExecutor = MemoizedSupplier.valueOf(() -> ConcurrentUtils.newSingleThreadExecutor((String)(id + "-groupManagement")));
        this.executor = MemoizedSupplier.valueOf(() -> ConcurrentUtils.newThreadPoolWithMax((boolean)RaftServerConfigKeys.ThreadPool.proxyCached((RaftProperties)properties), (int)RaftServerConfigKeys.ThreadPool.proxySize((RaftProperties)properties), (String)(id + "-impl")));
        TimeDuration sleepDeviationThreshold = RaftServerConfigKeys.sleepDeviationThreshold((RaftProperties)properties);
        TimeDuration closeThreshold = RaftServerConfigKeys.closeThreshold((RaftProperties)properties);
        TimeDuration leaderStepDownWaitTime = RaftServerConfigKeys.LeaderElection.leaderStepDownWaitTime((RaftProperties)properties);
        this.pauseMonitor = JvmPauseMonitor.newBuilder().setName((Object)id).setSleepDeviationThreshold(sleepDeviationThreshold).setHandler(extraSleep -> this.handleJvmPause((TimeDuration)extraSleep, closeThreshold, leaderStepDownWaitTime)).build();
        this.threadGroup = threadGroup == null ? new ThreadGroup(this.id.toString()) : threadGroup;
    }

    private void handleJvmPause(TimeDuration extraSleep, TimeDuration closeThreshold, TimeDuration stepDownThreshold) throws IOException {
        if (extraSleep.compareTo(closeThreshold) > 0) {
            LOG.error("{}: JVM pause detected {} longer than the close-threshold {}, shutting down ...", new Object[]{this.getId(), extraSleep.toString(TimeUnit.SECONDS, 3), closeThreshold.toString(TimeUnit.SECONDS, 3)});
            this.close();
        } else if (extraSleep.compareTo(stepDownThreshold) > 0) {
            LOG.warn("{}: JVM pause detected {} longer than the step-down-threshold {}", new Object[]{this.getId(), extraSleep.toString(TimeUnit.SECONDS, 3), stepDownThreshold.toString(TimeUnit.SECONDS, 3)});
            this.getImpls().forEach(RaftServerImpl::stepDownOnJvmPause);
        }
    }

    void initGroups(RaftGroup group, RaftStorage.StartupOption option) {
        Optional<RaftGroup> raftGroup = Optional.ofNullable(group);
        RaftGroupId raftGroupId = raftGroup.map(RaftGroup::getGroupId).orElse(null);
        Predicate<RaftGroupId> shouldAdd = gid -> gid != null && !gid.equals((Object)raftGroupId);
        ConcurrentUtils.parallelForEachAsync((Collection)RaftServerConfigKeys.storageDir((RaftProperties)this.properties), dir -> Optional.ofNullable(dir.listFiles()).map(Arrays::stream).orElse(Stream.empty()).filter(File::isDirectory).forEach(sub -> this.initGroupDir((File)sub, shouldAdd)), (Executor)((Executor)this.executor.get())).join();
        raftGroup.ifPresent(g -> this.addGroup((RaftGroup)g, option));
    }

    private void initGroupDir(File sub, Predicate<RaftGroupId> shouldAdd) {
        try {
            LOG.info("{}: found a subdirectory {}", (Object)this.getId(), (Object)sub);
            RaftGroupId groupId = null;
            try {
                groupId = RaftGroupId.valueOf((UUID)UUID.fromString(sub.getName()));
            }
            catch (Exception e) {
                LOG.info("{}: The directory {} is not a group directory; ignoring it. ", (Object)this.getId(), (Object)sub.getAbsolutePath());
            }
            if (shouldAdd.test(groupId)) {
                this.addGroup(RaftGroup.valueOf((RaftGroupId)groupId, (RaftPeer[])new RaftPeer[0]), RaftStorage.StartupOption.RECOVER);
            }
        }
        catch (Exception e) {
            LOG.warn(this.getId() + ": Failed to initialize the group directory " + sub.getAbsolutePath() + ".  Ignoring it", (Throwable)e);
        }
    }

    void addRaftPeers(Collection<RaftPeer> peers) {
        List others = peers.stream().filter(p -> !p.getId().equals((Object)this.getId())).collect(Collectors.toList());
        this.getServerRpc().addRaftPeers(others);
        this.getDataStreamServerRpc().addRaftPeers(others);
    }

    private CompletableFuture<RaftServerImpl> newRaftServerImpl(RaftGroup group, RaftStorage.StartupOption option) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                this.addRaftPeers(group.getPeers());
                return new RaftServerImpl(group, (StateMachine)this.stateMachineRegistry.apply((Object)group.getGroupId()), this, option);
            }
            catch (IOException e) {
                throw new CompletionException(this.getId() + ": Failed to initialize server for " + group, e);
            }
        }, (Executor)this.implExecutor.get());
    }

    private static String getIdStringFrom(RaftServerRpc rpc) {
        InetSocketAddress address = null;
        try {
            address = rpc.getInetSocketAddress();
        }
        catch (Exception e) {
            LOG.warn("Failed to get InetSocketAddress from " + rpc.getRpcType() + " rpc server", (Throwable)e);
        }
        return address != null ? address.getHostName() + "_" + address.getPort() : rpc.getRpcType() + "-" + UUID.randomUUID();
    }

    public RaftPeerId getId() {
        return this.id;
    }

    public RaftPeer getPeer() {
        return this.peerSupplier.get();
    }

    private RaftPeer buildRaftPeer() {
        return RaftPeer.newBuilder().setId(this.getId()).setAddress(this.getServerRpc().getInetSocketAddress()).setDataStreamAddress(this.getDataStreamServerRpc().getInetSocketAddress()).setClientAddress(this.getServerRpc().getClientServerAddress()).setAdminAddress(this.getServerRpc().getAdminServerAddress()).build();
    }

    public List<RaftGroupId> getGroupIds() {
        return this.impls.getGroupIds();
    }

    public Iterable<RaftGroup> getGroups() throws IOException {
        return this.getImpls().stream().map(RaftServer.Division::getGroup).collect(Collectors.toList());
    }

    public ServerFactory getFactory() {
        return this.factory;
    }

    public RaftProperties getProperties() {
        return this.properties;
    }

    public RaftServerRpc getServerRpc() {
        return this.serverRpc;
    }

    public DataStreamServerRpc getDataStreamServerRpc() {
        return this.dataStreamServerRpc;
    }

    private CompletableFuture<RaftServerImpl> addGroup(RaftGroup group, RaftStorage.StartupOption option) {
        return this.impls.addNew(group, option);
    }

    private CompletableFuture<RaftServerImpl> getImplFuture(RaftGroupId groupId) {
        return this.impls.get(groupId);
    }

    private RaftServerImpl getImpl(RaftProtos.RaftRpcRequestProto proto) throws IOException {
        return this.getImpl(ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)proto.getRaftGroupId()));
    }

    private RaftServerImpl getImpl(RaftGroupId groupId) throws IOException {
        Objects.requireNonNull(groupId, "groupId == null");
        return (RaftServerImpl)IOUtils.getFromFuture(this.getImplFuture(groupId), this::getId);
    }

    List<RaftServerImpl> getImpls() throws IOException {
        ArrayList<RaftServerImpl> list = new ArrayList<RaftServerImpl>();
        for (CompletableFuture<RaftServerImpl> f : this.impls.getAll()) {
            list.add((RaftServerImpl)IOUtils.getFromFuture(f, this::getId));
        }
        return list;
    }

    public RaftServer.Division getDivision(RaftGroupId groupId) throws IOException {
        return this.getImpl(groupId);
    }

    public LifeCycle.State getLifeCycleState() {
        return this.lifeCycle.getCurrentState();
    }

    ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public void start() throws IOException {
        this.lifeCycle.startAndTransition(this::startImpl, new Class[]{IOException.class});
    }

    private void startImpl() throws IOException {
        ConcurrentUtils.parallelForEachAsync(this.getImpls(), RaftServerImpl::start, (Executor)((Executor)this.executor.get())).join();
        LOG.info("{}: start RPC server", (Object)this.getId());
        this.getServerRpc().start();
        this.getDataStreamServerRpc().start();
        this.pauseMonitor.start();
    }

    public void close() {
        this.lifeCycle.checkStateAndClose(() -> {
            LOG.info("{}: close", (Object)this.getId());
            try {
                ConcurrentUtils.shutdownAndWait((ExecutorService)((ExecutorService)this.implExecutor.get()));
            }
            catch (Exception ignored) {
                LOG.warn(this.getId() + ": Failed to shutdown implExecutor", (Throwable)ignored);
            }
            this.impls.close();
            try {
                this.getServerRpc().close();
            }
            catch (IOException ignored) {
                LOG.warn(this.getId() + ": Failed to close " + this.getRpcType() + " server", (Throwable)ignored);
            }
            try {
                this.getDataStreamServerRpc().close();
            }
            catch (IOException ignored) {
                LOG.warn(this.getId() + ": Failed to close " + SupportedDataStreamType.NETTY + " server", (Throwable)ignored);
            }
            try {
                ConcurrentUtils.shutdownAndWait((ExecutorService)((ExecutorService)this.executor.get()));
            }
            catch (Exception ignored) {
                LOG.warn(this.getId() + ": Failed to shutdown executor", (Throwable)ignored);
            }
        });
        this.pauseMonitor.stop();
    }

    public CompletableFuture<RaftClientReply> submitClientRequestAsync(RaftClientRequest request) {
        return this.getImplFuture(request.getRaftGroupId()).thenCompose(impl -> impl.executeSubmitClientRequestAsync(request));
    }

    public RaftClientReply submitClientRequest(RaftClientRequest request) throws IOException {
        return this.getImpl(request.getRaftGroupId()).submitClientRequest(request);
    }

    public RaftClientReply setConfiguration(SetConfigurationRequest request) throws IOException {
        return this.getImpl(request.getRaftGroupId()).setConfiguration(request);
    }

    public RaftClientReply transferLeadership(TransferLeadershipRequest request) throws IOException {
        return this.getImpl(request.getRaftGroupId()).transferLeadership(request);
    }

    public RaftClientReply groupManagement(GroupManagementRequest request) throws IOException {
        return RaftServerImpl.waitForReply(this.getId(), (RaftClientRequest)request, this.groupManagementAsync(request), e -> RaftClientReply.newBuilder().setRequest((RaftClientRequest)request).setException(e).build());
    }

    public CompletableFuture<RaftClientReply> groupManagementAsync(GroupManagementRequest request) {
        RaftGroupId groupId = request.getRaftGroupId();
        if (groupId == null) {
            return JavaUtils.completeExceptionally((Throwable)new GroupMismatchException(this.getId() + ": Request group id == null"));
        }
        GroupManagementRequest.Add add = request.getAdd();
        if (add != null) {
            return this.groupAddAsync(request, add.getGroup(), add.isFormat());
        }
        GroupManagementRequest.Remove remove = request.getRemove();
        if (remove != null) {
            return this.groupRemoveAsync((RaftClientRequest)request, remove.getGroupId(), remove.isDeleteDirectory(), remove.isRenameDirectory());
        }
        return JavaUtils.completeExceptionally((Throwable)new UnsupportedOperationException(this.getId() + ": Request not supported " + request));
    }

    private CompletableFuture<RaftClientReply> groupAddAsync(GroupManagementRequest request, RaftGroup newGroup, boolean format) {
        if (!request.getRaftGroupId().equals((Object)newGroup.getGroupId())) {
            return JavaUtils.completeExceptionally((Throwable)new GroupMismatchException(this.getId() + ": Request group id (" + request.getRaftGroupId() + ") does not match the new group " + newGroup));
        }
        return ((CompletableFuture)this.impls.addNew(newGroup, format ? RaftStorage.StartupOption.FORMAT : RaftStorage.StartupOption.RECOVER).thenApplyAsync(newImpl -> {
            LOG.debug("{}: newImpl = {}", (Object)this.getId(), newImpl);
            try {
                boolean started = newImpl.start();
                Preconditions.assertTrue((boolean)started, () -> this.getId() + ": failed to start a new impl: " + newImpl);
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
            return newImpl.newSuccessReply((RaftClientRequest)request);
        }, (Executor)this.implExecutor.get())).whenComplete((raftClientReply, throwable) -> {
            if (throwable != null) {
                if (!(throwable.getCause() instanceof AlreadyExistsException)) {
                    this.impls.remove(newGroup.getGroupId());
                    LOG.warn(this.getId() + ": Failed groupAdd* " + request, throwable);
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug(this.getId() + ": Failed groupAdd* " + request, throwable);
                }
            }
        });
    }

    private CompletableFuture<RaftClientReply> groupRemoveAsync(RaftClientRequest request, RaftGroupId groupId, boolean deleteDirectory, boolean renameDirectory) {
        if (!request.getRaftGroupId().equals((Object)groupId)) {
            return JavaUtils.completeExceptionally((Throwable)new GroupMismatchException(this.getId() + ": Request group id (" + request.getRaftGroupId() + ") does not match the given group id " + groupId));
        }
        CompletableFuture<RaftServerImpl> f = this.impls.remove(groupId);
        if (f == null) {
            return JavaUtils.completeExceptionally((Throwable)new GroupMismatchException(this.getId() + ": Group " + groupId + " not found."));
        }
        return f.thenApply(impl -> {
            impl.groupRemove(deleteDirectory, renameDirectory);
            return impl.newSuccessReply(request);
        });
    }

    public RaftClientReply snapshotManagement(SnapshotManagementRequest request) throws IOException {
        return RaftServerImpl.waitForReply(this.getId(), (RaftClientRequest)request, this.snapshotManagementAsync(request), e -> RaftClientReply.newBuilder().setRequest((RaftClientRequest)request).setException(e).build());
    }

    public CompletableFuture<RaftClientReply> snapshotManagementAsync(SnapshotManagementRequest request) {
        RaftGroupId groupId = request.getRaftGroupId();
        if (groupId == null) {
            return JavaUtils.completeExceptionally((Throwable)new GroupMismatchException(this.getId() + ": Request group id == null"));
        }
        SnapshotManagementRequest.Create create = request.getCreate();
        if (create != null) {
            return this.createAsync(request);
        }
        return JavaUtils.completeExceptionally((Throwable)new UnsupportedOperationException(this.getId() + ": Request not supported " + request));
    }

    private CompletableFuture<RaftClientReply> createAsync(SnapshotManagementRequest request) {
        return this.getImplFuture(request.getRaftGroupId()).thenCompose(impl -> impl.executeSubmitServerRequestAsync(() -> impl.takeSnapshotAsync(request)));
    }

    public RaftClientReply leaderElectionManagement(LeaderElectionManagementRequest request) throws IOException {
        return RaftServerImpl.waitForReply(this.getId(), (RaftClientRequest)request, this.leaderElectionManagementAsync(request), e -> RaftClientReply.newBuilder().setRequest((RaftClientRequest)request).setException(e).build());
    }

    public CompletableFuture<RaftClientReply> leaderElectionManagementAsync(LeaderElectionManagementRequest request) {
        return this.getImplFuture(request.getRaftGroupId()).thenCompose(impl -> impl.executeSubmitServerRequestAsync(() -> impl.leaderElectionManagementAsync(request)));
    }

    public GroupListReply getGroupList(GroupListRequest request) {
        return new GroupListReply((RaftClientRequest)request, (List)this.getGroupIds());
    }

    public CompletableFuture<GroupListReply> getGroupListAsync(GroupListRequest request) {
        return CompletableFuture.completedFuture(this.getGroupList(request));
    }

    public GroupInfoReply getGroupInfo(GroupInfoRequest request) throws IOException {
        return RaftServerImpl.waitForReply(this.getId(), (RaftClientRequest)request, this.getGroupInfoAsync(request), r -> null);
    }

    public CompletableFuture<GroupInfoReply> getGroupInfoAsync(GroupInfoRequest request) {
        return this.getImplFuture(request.getRaftGroupId()).thenApplyAsync(server -> server.getGroupInfo(request));
    }

    public CompletableFuture<RaftClientReply> setConfigurationAsync(SetConfigurationRequest request) {
        return this.getImplFuture(request.getRaftGroupId()).thenCompose(impl -> impl.executeSubmitServerRequestAsync(() -> impl.setConfigurationAsync(request)));
    }

    public CompletableFuture<RaftClientReply> transferLeadershipAsync(TransferLeadershipRequest request) {
        return this.getImplFuture(request.getRaftGroupId()).thenCompose(impl -> impl.executeSubmitServerRequestAsync(() -> impl.transferLeadershipAsync(request)));
    }

    public RaftProtos.RequestVoteReplyProto requestVote(RaftProtos.RequestVoteRequestProto request) throws IOException {
        return this.getImpl(request.getServerRequest()).requestVote(request);
    }

    public RaftProtos.StartLeaderElectionReplyProto startLeaderElection(RaftProtos.StartLeaderElectionRequestProto request) throws IOException {
        return this.getImpl(request.getServerRequest()).startLeaderElection(request);
    }

    public CompletableFuture<RaftProtos.AppendEntriesReplyProto> appendEntriesAsync(RaftProtos.AppendEntriesRequestProto request) {
        RaftGroupId groupId = ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)request.getServerRequest().getRaftGroupId());
        return this.getImplFuture(groupId).thenCompose(impl -> (CompletionStage)JavaUtils.callAsUnchecked(() -> impl.appendEntriesAsync(request), CompletionException::new));
    }

    public CompletableFuture<RaftProtos.ReadIndexReplyProto> readIndexAsync(RaftProtos.ReadIndexRequestProto request) throws IOException {
        RaftGroupId groupId = ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)request.getServerRequest().getRaftGroupId());
        return this.getImplFuture(groupId).thenCompose(impl -> impl.executeSubmitServerRequestAsync(() -> impl.readIndexAsync(request)));
    }

    public RaftProtos.AppendEntriesReplyProto appendEntries(RaftProtos.AppendEntriesRequestProto request) throws IOException {
        return this.getImpl(request.getServerRequest()).appendEntries(request);
    }

    public RaftProtos.InstallSnapshotReplyProto installSnapshot(RaftProtos.InstallSnapshotRequestProto request) throws IOException {
        return this.getImpl(request.getServerRequest()).installSnapshot(request);
    }

    public String toString() {
        return this.getId() + String.format(":%9s ", this.lifeCycle.getCurrentState()) + this.impls;
    }

    class ImplMap
    implements Closeable {
        private final ConcurrentMap<RaftGroupId, CompletableFuture<RaftServerImpl>> map = new ConcurrentHashMap<RaftGroupId, CompletableFuture<RaftServerImpl>>();
        private boolean isClosed = false;

        ImplMap() {
        }

        synchronized CompletableFuture<RaftServerImpl> addNew(RaftGroup group, RaftStorage.StartupOption option) {
            if (this.isClosed) {
                return JavaUtils.completeExceptionally((Throwable)new AlreadyClosedException(RaftServerProxy.this.getId() + ": Failed to add " + group + " since the server is already closed"));
            }
            if (this.containsGroup(group.getGroupId())) {
                return JavaUtils.completeExceptionally((Throwable)new AlreadyExistsException(RaftServerProxy.this.getId() + ": Failed to add " + group + " since the group already exists in the map."));
            }
            RaftGroupId groupId = group.getGroupId();
            CompletableFuture newImpl = RaftServerProxy.this.newRaftServerImpl(group, option);
            CompletableFuture<RaftServerImpl> previous = this.map.put(groupId, newImpl);
            Preconditions.assertNull(previous, (String)"previous");
            RaftServer.LOG.info("{}: addNew {} returns {}", new Object[]{RaftServerProxy.this.getId(), group, this.toString(groupId, newImpl)});
            return newImpl;
        }

        synchronized CompletableFuture<RaftServerImpl> remove(RaftGroupId groupId) {
            if (!this.map.containsKey(groupId)) {
                RaftServer.LOG.warn("{}: does not contain group: {}", (Object)RaftServerProxy.this.getId(), (Object)groupId);
                return null;
            }
            CompletableFuture future = (CompletableFuture)this.map.remove(groupId);
            RaftServer.LOG.info("{}: remove {}", (Object)RaftServerProxy.this.getId(), (Object)this.toString(groupId, future));
            return future;
        }

        @Override
        public synchronized void close() {
            if (this.isClosed) {
                RaftServer.LOG.info("{} is already closed.", (Object)RaftServerProxy.this.getId());
                return;
            }
            this.isClosed = true;
            ConcurrentUtils.parallelForEachAsync(this.map.entrySet(), entry -> this.close((RaftGroupId)entry.getKey(), (CompletableFuture)entry.getValue()), (Executor)((Executor)RaftServerProxy.this.executor.get()));
        }

        private void close(RaftGroupId groupId, CompletableFuture<RaftServerImpl> future) {
            RaftServerImpl impl;
            try {
                impl = future.join();
            }
            catch (Throwable t) {
                RaftServer.LOG.warn("{}: Failed to join the division for {}", new Object[]{RaftServerProxy.this.getId(), groupId, t});
                return;
            }
            try {
                impl.close();
            }
            catch (Throwable t) {
                RaftServer.LOG.warn("{}: Failed to close the division for {}", new Object[]{RaftServerProxy.this.getId(), groupId, t});
            }
            impl.getStateMachine().event().notifyServerShutdown(impl.getRoleInfoProto(), true);
        }

        synchronized List<RaftGroupId> getGroupIds() {
            return new ArrayList<RaftGroupId>(this.map.keySet());
        }

        synchronized List<CompletableFuture<RaftServerImpl>> getAll() {
            return new ArrayList<CompletableFuture<RaftServerImpl>>(this.map.values());
        }

        CompletableFuture<RaftServerImpl> get(RaftGroupId groupId) {
            CompletableFuture i = (CompletableFuture)this.map.get(groupId);
            if (i == null) {
                return JavaUtils.completeExceptionally((Throwable)new GroupMismatchException(RaftServerProxy.this.getId() + ": " + groupId + " not found."));
            }
            return i;
        }

        boolean containsGroup(RaftGroupId groupId) {
            return this.map.containsKey(groupId);
        }

        public synchronized String toString() {
            if (this.map.isEmpty()) {
                return "<EMPTY>";
            }
            if (this.map.size() == 1) {
                return this.toString(this.map.entrySet().iterator().next());
            }
            StringBuilder b = new StringBuilder("[");
            this.map.entrySet().forEach(e -> b.append("\n  ").append(this.toString((Map.Entry<RaftGroupId, CompletableFuture<RaftServerImpl>>)e)));
            return b.append("] size=").append(this.map.size()).toString();
        }

        String toString(Map.Entry<RaftGroupId, CompletableFuture<RaftServerImpl>> e) {
            return this.toString(e.getKey(), e.getValue());
        }

        String toString(RaftGroupId groupId, CompletableFuture<RaftServerImpl> f) {
            return "" + (f != null && f.isDone() ? f.join() : groupId + ":" + f);
        }
    }
}

