/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.ProtoUtils;

class CommitInfoCache {
    private final ConcurrentMap<RaftPeerId, Long> map = new ConcurrentHashMap<RaftPeerId, Long>();

    CommitInfoCache() {
    }

    Optional<Long> get(RaftPeerId id) {
        return Optional.ofNullable((Long)this.map.get(id));
    }

    RaftProtos.CommitInfoProto update(RaftPeer peer, long newCommitIndex) {
        Objects.requireNonNull(peer, "peer == null");
        long updated = this.update(peer.getId(), newCommitIndex);
        return ProtoUtils.toCommitInfoProto((RaftPeer)peer, (long)updated);
    }

    long update(RaftPeerId peerId, long newCommitIndex) {
        Objects.requireNonNull(peerId, "peerId == null");
        return this.map.compute(peerId, (id, oldCommitIndex) -> {
            long old;
            if (oldCommitIndex != null && (old = oldCommitIndex.longValue()) >= newCommitIndex) {
                return old;
            }
            return newCommitIndex;
        });
    }

    void update(RaftProtos.CommitInfoProto newInfo) {
        RaftPeerId id = RaftPeerId.valueOf((ByteString)newInfo.getServer().getId());
        this.update(id, newInfo.getCommitIndex());
    }

    public String toString() {
        return JavaUtils.getClassSimpleName(this.getClass()) + ":" + this.map;
    }
}

