/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.datanode;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;

public class RemoveDataNodePlan
extends ConfigPhysicalPlan {
    private List<TDataNodeLocation> dataNodeLocations = new ArrayList<TDataNodeLocation>();

    public RemoveDataNodePlan() {
        super(ConfigPhysicalPlanType.RemoveDataNode);
    }

    public RemoveDataNodePlan(List<TDataNodeLocation> dataNodeLocations) {
        this();
        this.dataNodeLocations = dataNodeLocations;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        stream.writeInt(this.dataNodeLocations.size());
        this.dataNodeLocations.forEach(location -> ThriftCommonsSerDeUtils.serializeTDataNodeLocation((TDataNodeLocation)location, (DataOutputStream)stream));
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        int dataNodeLocationSize = buffer.getInt();
        for (int i = 0; i < dataNodeLocationSize; ++i) {
            this.dataNodeLocations.add(ThriftCommonsSerDeUtils.deserializeTDataNodeLocation((ByteBuffer)buffer));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RemoveDataNodePlan that = (RemoveDataNodePlan)o;
        return this.dataNodeLocations.equals(that.dataNodeLocations);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.dataNodeLocations);
    }

    public List<TDataNodeLocation> getDataNodeLocations() {
        return this.dataNodeLocations;
    }

    public String toString() {
        return "{RemoveDataNodeReq: TDataNodeLocations: " + this.getDataNodeLocations() + "}";
    }
}

