/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QualifiedName;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;

public class SetTableComment
extends Statement {
    private final QualifiedName tableName;
    private final boolean ifExists;
    @Nullable
    private final String comment;
    private final boolean view;

    public SetTableComment(@Nonnull NodeLocation location, QualifiedName tableName, boolean ifExists, @Nullable String comment, boolean view) {
        super(location);
        this.tableName = tableName;
        this.ifExists = ifExists;
        this.comment = comment;
        this.view = view;
    }

    public QualifiedName getTableName() {
        return this.tableName;
    }

    public boolean ifExists() {
        return this.ifExists;
    }

    @Nullable
    public String getComment() {
        return this.comment;
    }

    public boolean isView() {
        return this.view;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSetTableComment(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.tableName, this.ifExists, this.comment, this.view);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetTableComment that = (SetTableComment)o;
        return this.ifExists == that.ifExists && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.comment, that.comment) && this.view == that.view;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableName", (Object)this.tableName).add("ifExists", this.ifExists).add("comment", (Object)this.comment).add("view", this.view).toString();
    }
}

