/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.AggregationValuePointer;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.ClassifierValuePointer;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.MatchNumberValuePointer;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.ScalarValuePointer;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.ValuePointer;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BooleanLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class ExpressionAndValuePointers {
    public static final ExpressionAndValuePointers TRUE = new ExpressionAndValuePointers(BooleanLiteral.TRUE_LITERAL, (List<Assignment>)ImmutableList.of());
    private final Expression expression;
    private final List<Assignment> assignments;

    public ExpressionAndValuePointers(Expression expression, List<Assignment> assignments) {
        this.expression = Objects.requireNonNull(expression, "expression is null");
        this.assignments = ImmutableList.copyOf(assignments);
    }

    public Expression getExpression() {
        return this.expression;
    }

    public List<Assignment> getAssignments() {
        return this.assignments;
    }

    public List<Symbol> getInputSymbols() {
        Set localInputs = (Set)this.assignments.stream().filter(assignment -> assignment.getValuePointer() instanceof ClassifierValuePointer || assignment.getValuePointer() instanceof MatchNumberValuePointer).map(Assignment::getSymbol).collect(ImmutableSet.toImmutableSet());
        ImmutableList.Builder inputSymbols = ImmutableList.builder();
        for (Assignment assignment2 : this.assignments) {
            ScalarValuePointer pointer;
            Symbol symbol;
            ValuePointer valuePointer = assignment2.getValuePointer();
            if (!(valuePointer instanceof ScalarValuePointer) || localInputs.contains(symbol = (pointer = (ScalarValuePointer)valuePointer).getInputSymbol())) continue;
            inputSymbols.add((Object)symbol);
        }
        return inputSymbols.build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExpressionAndValuePointers o = (ExpressionAndValuePointers)obj;
        return Objects.equals(this.expression, o.expression) && Objects.equals(this.assignments, o.assignments);
    }

    public int hashCode() {
        return Objects.hash(this.expression, this.assignments);
    }

    public static void serialize(ExpressionAndValuePointers valuePointers, ByteBuffer byteBuffer) {
        Expression.serialize(valuePointers.expression, byteBuffer);
        ReadWriteIOUtils.write((int)valuePointers.assignments.size(), (ByteBuffer)byteBuffer);
        for (Assignment assignment : valuePointers.assignments) {
            Assignment.serialize(assignment, byteBuffer);
        }
    }

    public static void serialize(ExpressionAndValuePointers valuePointers, DataOutputStream stream) throws IOException {
        Expression.serialize(valuePointers.expression, stream);
        ReadWriteIOUtils.write((int)valuePointers.assignments.size(), (OutputStream)stream);
        for (Assignment assignment : valuePointers.assignments) {
            Assignment.serialize(assignment, stream);
        }
    }

    public static ExpressionAndValuePointers deserialize(ByteBuffer byteBuffer) {
        Expression expression = Expression.deserialize(byteBuffer);
        int assignmentsSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<Assignment> assignments = new ArrayList<Assignment>(assignmentsSize);
        for (int i = 0; i < assignmentsSize; ++i) {
            assignments.add(Assignment.deserialize(byteBuffer));
        }
        return new ExpressionAndValuePointers(expression, assignments);
    }

    public static class Assignment {
        private final Symbol symbol;
        private final ValuePointer valuePointer;

        public Assignment(Symbol symbol, ValuePointer valuePointer) {
            this.symbol = symbol;
            this.valuePointer = valuePointer;
        }

        public Symbol getSymbol() {
            return this.symbol;
        }

        public ValuePointer getValuePointer() {
            return this.valuePointer;
        }

        public int hashCode() {
            return Objects.hash(this.symbol, this.valuePointer);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Assignment that = (Assignment)o;
            return Objects.equals(this.symbol, that.symbol) && Objects.equals(this.valuePointer, that.valuePointer);
        }

        public String toString() {
            return "Assignment{symbol=" + this.symbol + ", valuePointer=" + this.valuePointer + '}';
        }

        public static void serialize(Assignment assignment, ByteBuffer byteBuffer) {
            Symbol.serialize(assignment.symbol, byteBuffer);
            if (assignment.valuePointer instanceof MatchNumberValuePointer) {
                ReadWriteIOUtils.write((int)0, (ByteBuffer)byteBuffer);
            } else if (assignment.valuePointer instanceof ClassifierValuePointer) {
                ReadWriteIOUtils.write((int)1, (ByteBuffer)byteBuffer);
            } else if (assignment.valuePointer instanceof ScalarValuePointer) {
                ReadWriteIOUtils.write((int)2, (ByteBuffer)byteBuffer);
            } else if (assignment.valuePointer instanceof AggregationValuePointer) {
                ReadWriteIOUtils.write((int)3, (ByteBuffer)byteBuffer);
            } else {
                throw new IllegalArgumentException("Unknown ValuePointer type");
            }
            if (assignment.valuePointer instanceof MatchNumberValuePointer) {
                MatchNumberValuePointer.serialize((MatchNumberValuePointer)assignment.valuePointer, byteBuffer);
            } else if (assignment.valuePointer instanceof ClassifierValuePointer) {
                ClassifierValuePointer.serialize((ClassifierValuePointer)assignment.valuePointer, byteBuffer);
            } else if (assignment.valuePointer instanceof ScalarValuePointer) {
                ScalarValuePointer.serialize((ScalarValuePointer)assignment.valuePointer, byteBuffer);
            } else if (assignment.valuePointer instanceof AggregationValuePointer) {
                AggregationValuePointer.serialize((AggregationValuePointer)assignment.valuePointer, byteBuffer);
            } else {
                throw new IllegalArgumentException("Unknown ValuePointer type");
            }
        }

        public static void serialize(Assignment assignment, DataOutputStream stream) throws IOException {
            Symbol.serialize(assignment.symbol, stream);
            if (assignment.valuePointer instanceof MatchNumberValuePointer) {
                ReadWriteIOUtils.write((int)0, (OutputStream)stream);
            } else if (assignment.valuePointer instanceof ClassifierValuePointer) {
                ReadWriteIOUtils.write((int)1, (OutputStream)stream);
            } else if (assignment.valuePointer instanceof ScalarValuePointer) {
                ReadWriteIOUtils.write((int)2, (OutputStream)stream);
            } else if (assignment.valuePointer instanceof AggregationValuePointer) {
                ReadWriteIOUtils.write((int)3, (OutputStream)stream);
            } else {
                throw new IllegalArgumentException("Unknown ValuePointer type");
            }
            if (assignment.valuePointer instanceof MatchNumberValuePointer) {
                MatchNumberValuePointer.serialize((MatchNumberValuePointer)assignment.valuePointer, stream);
            } else if (assignment.valuePointer instanceof ClassifierValuePointer) {
                ClassifierValuePointer.serialize((ClassifierValuePointer)assignment.valuePointer, stream);
            } else if (assignment.valuePointer instanceof ScalarValuePointer) {
                ScalarValuePointer.serialize((ScalarValuePointer)assignment.valuePointer, stream);
            } else if (assignment.valuePointer instanceof AggregationValuePointer) {
                AggregationValuePointer.serialize((AggregationValuePointer)assignment.valuePointer, stream);
            } else {
                throw new IllegalArgumentException("Unknown ValuePointer type");
            }
        }

        public static Assignment deserialize(ByteBuffer byteBuffer) {
            ValuePointer valuePointer;
            Symbol symbol = Symbol.deserialize(byteBuffer);
            int type = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
            if (type == 0) {
                valuePointer = MatchNumberValuePointer.deserialize(byteBuffer);
            } else if (type == 1) {
                valuePointer = ClassifierValuePointer.deserialize(byteBuffer);
            } else if (type == 2) {
                valuePointer = ScalarValuePointer.deserialize(byteBuffer);
            } else if (type == 3) {
                valuePointer = AggregationValuePointer.deserialize(byteBuffer);
            } else {
                throw new IllegalArgumentException("Unknown ValuePointer type");
            }
            return new Assignment(symbol, valuePointer);
        }
    }
}

