/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SourceNode;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ColumnSchema;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.Metadata;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.QualifiedObjectName;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public abstract class TableScanNode
extends SourceNode {
    protected QualifiedObjectName qualifiedObjectName;
    protected List<Symbol> outputSymbols;
    protected Map<Symbol, ColumnSchema> assignments;
    @Nullable
    protected Expression pushDownPredicate;
    protected long pushDownLimit;
    protected long pushDownOffset;
    protected TRegionReplicaSet regionReplicaSet;

    public TableScanNode(PlanNodeId id, QualifiedObjectName qualifiedObjectName, List<Symbol> outputSymbols, Map<Symbol, ColumnSchema> assignments) {
        super(id);
        this.qualifiedObjectName = qualifiedObjectName;
        this.outputSymbols = outputSymbols;
        this.assignments = assignments;
    }

    public TableScanNode(PlanNodeId id, QualifiedObjectName qualifiedObjectName, List<Symbol> outputSymbols, Map<Symbol, ColumnSchema> assignments, Expression pushDownPredicate, long pushDownLimit, long pushDownOffset) {
        super(id);
        this.qualifiedObjectName = qualifiedObjectName;
        this.outputSymbols = outputSymbols;
        this.assignments = assignments;
        this.pushDownPredicate = pushDownPredicate;
        this.pushDownLimit = pushDownLimit;
        this.pushDownOffset = pushDownOffset;
    }

    protected TableScanNode() {
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitTableScan(this, context);
    }

    @Override
    public List<PlanNode> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public void addChild(PlanNode child) {
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return this.outputSymbols.stream().map(Symbol::getName).collect(Collectors.toList());
    }

    public List<Symbol> getIdColumnsInTableStore(Metadata metadata, SessionInfo session) {
        return Objects.requireNonNull(metadata.getTableSchema(session, this.qualifiedObjectName).orElse(null)).getColumns().stream().filter(columnSchema -> columnSchema.getColumnCategory() == TsTableColumnCategory.TAG).map(columnSchema -> Symbol.of(columnSchema.getName())).collect(Collectors.toList());
    }

    public boolean isMeasurementOrTimeColumn(Symbol symbol) {
        ColumnSchema columnSchema = this.assignments.get(symbol);
        return columnSchema != null && (columnSchema.getColumnCategory() == TsTableColumnCategory.FIELD || columnSchema.getColumnCategory() == TsTableColumnCategory.TIME);
    }

    public boolean isTimeColumn(Symbol symbol) {
        return TableScanNode.isTimeColumn(symbol, this.assignments);
    }

    public Optional<Symbol> getTimeColumn() {
        return TableScanNode.getTimeColumn(this.assignments);
    }

    public static Optional<Symbol> getTimeColumn(Map<Symbol, ColumnSchema> assignments) {
        for (Map.Entry<Symbol, ColumnSchema> entry : assignments.entrySet()) {
            if (entry.getValue().getColumnCategory() != TsTableColumnCategory.TIME) continue;
            return Optional.of(entry.getKey());
        }
        return Optional.empty();
    }

    public static boolean isTimeColumn(Symbol symbol, Map<Symbol, ColumnSchema> columnSchemaMap) {
        ColumnSchema columnSchema = columnSchemaMap.get(symbol);
        return columnSchema != null && columnSchema.getColumnCategory() == TsTableColumnCategory.TIME;
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.outputSymbols;
    }

    @Override
    public void open() throws Exception {
    }

    @Override
    public void close() throws Exception {
    }

    public QualifiedObjectName getQualifiedObjectName() {
        return this.qualifiedObjectName;
    }

    public void setOutputSymbols(List<Symbol> outputSymbols) {
        this.outputSymbols = outputSymbols;
    }

    public void setAssignments(Map<Symbol, ColumnSchema> assignments) {
        this.assignments = assignments;
    }

    public Map<Symbol, ColumnSchema> getAssignments() {
        return this.assignments;
    }

    public long getPushDownLimit() {
        return this.pushDownLimit;
    }

    public void setPushDownLimit(long pushDownLimit) {
        this.pushDownLimit = pushDownLimit;
    }

    public long getPushDownOffset() {
        return this.pushDownOffset;
    }

    public void setPushDownOffset(long pushDownOffset) {
        this.pushDownOffset = pushDownOffset;
    }

    public Expression getPushDownPredicate() {
        return this.pushDownPredicate;
    }

    public void setPushDownPredicate(@Nullable Expression pushDownPredicate) {
        this.pushDownPredicate = pushDownPredicate;
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return this.regionReplicaSet;
    }

    @Override
    public void setRegionReplicaSet(TRegionReplicaSet regionReplicaSet) {
        this.regionReplicaSet = regionReplicaSet;
    }

    protected static void serializeMemberVariables(TableScanNode node, ByteBuffer byteBuffer, boolean serializeOutputSymbols) {
        if (node.qualifiedObjectName.getDatabaseName() != null) {
            ReadWriteIOUtils.write((Boolean)true, (ByteBuffer)byteBuffer);
            ReadWriteIOUtils.write((String)node.qualifiedObjectName.getDatabaseName(), (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (ByteBuffer)byteBuffer);
        }
        ReadWriteIOUtils.write((String)node.qualifiedObjectName.getObjectName(), (ByteBuffer)byteBuffer);
        if (serializeOutputSymbols) {
            ReadWriteIOUtils.write((int)node.outputSymbols.size(), (ByteBuffer)byteBuffer);
            node.outputSymbols.forEach(symbol -> ReadWriteIOUtils.write((String)symbol.getName(), (ByteBuffer)byteBuffer));
        }
        ReadWriteIOUtils.write((int)node.assignments.size(), (ByteBuffer)byteBuffer);
        for (Map.Entry<Symbol, ColumnSchema> entry : node.assignments.entrySet()) {
            Symbol.serialize(entry.getKey(), byteBuffer);
            ColumnSchema.serialize(entry.getValue(), byteBuffer);
        }
        if (node.pushDownPredicate != null) {
            ReadWriteIOUtils.write((Boolean)true, (ByteBuffer)byteBuffer);
            Expression.serialize(node.pushDownPredicate, byteBuffer);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (ByteBuffer)byteBuffer);
        }
        ReadWriteIOUtils.write((long)node.pushDownLimit, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((long)node.pushDownOffset, (ByteBuffer)byteBuffer);
    }

    protected static void serializeMemberVariables(TableScanNode node, DataOutputStream stream, boolean serializeOutputSymbols) throws IOException {
        if (node.qualifiedObjectName.getDatabaseName() != null) {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
            ReadWriteIOUtils.write((String)node.qualifiedObjectName.getDatabaseName(), (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
        }
        ReadWriteIOUtils.write((String)node.qualifiedObjectName.getObjectName(), (OutputStream)stream);
        if (serializeOutputSymbols) {
            ReadWriteIOUtils.write((int)node.outputSymbols.size(), (OutputStream)stream);
            for (Symbol symbol : node.outputSymbols) {
                ReadWriteIOUtils.write((String)symbol.getName(), (OutputStream)stream);
            }
        }
        ReadWriteIOUtils.write((int)node.assignments.size(), (OutputStream)stream);
        for (Map.Entry entry : node.assignments.entrySet()) {
            Symbol.serialize((Symbol)entry.getKey(), stream);
            ColumnSchema.serialize((ColumnSchema)entry.getValue(), stream);
        }
        if (node.pushDownPredicate != null) {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
            Expression.serialize(node.pushDownPredicate, stream);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
        }
        ReadWriteIOUtils.write((long)node.pushDownLimit, (OutputStream)stream);
        ReadWriteIOUtils.write((long)node.pushDownOffset, (OutputStream)stream);
    }

    protected static void deserializeMemberVariables(ByteBuffer byteBuffer, TableScanNode node, boolean deserializeOutputSymbols) {
        int i;
        int size;
        boolean hasDatabaseName = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        String databaseName = null;
        if (hasDatabaseName) {
            databaseName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        }
        String tableName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        node.qualifiedObjectName = new QualifiedObjectName(databaseName, tableName);
        if (deserializeOutputSymbols) {
            size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
            ArrayList<Symbol> outputSymbols = new ArrayList<Symbol>(size);
            for (i = 0; i < size; ++i) {
                outputSymbols.add(Symbol.deserialize(byteBuffer));
            }
            node.outputSymbols = outputSymbols;
        }
        size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        HashMap<Symbol, ColumnSchema> assignments = new HashMap<Symbol, ColumnSchema>(size);
        for (i = 0; i < size; ++i) {
            assignments.put(Symbol.deserialize(byteBuffer), ColumnSchema.deserialize(byteBuffer));
        }
        node.assignments = assignments;
        boolean hasPushDownPredicate = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        if (hasPushDownPredicate) {
            node.pushDownPredicate = Expression.deserialize(byteBuffer);
        }
        node.pushDownLimit = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        node.pushDownOffset = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TableScanNode that = (TableScanNode)o;
        return Objects.equals(this.qualifiedObjectName, that.qualifiedObjectName) && Objects.equals(this.outputSymbols, that.outputSymbols) && Objects.equals(this.regionReplicaSet, that.regionReplicaSet);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.qualifiedObjectName, this.outputSymbols, this.regionReplicaSet);
    }

    public String toString() {
        return "TableScanNode-" + this.getPlanNodeId();
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((boolean)newChildren.isEmpty(), (Object)"newChildren is not empty");
        return this;
    }
}

