/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.expression;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.PatternAggregator;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.PhysicalAggregationPointer;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.PhysicalValueAccessor;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.PhysicalValuePointer;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.expression.Computation;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.matcher.ArrayView;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.partition.Partition;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.type.BooleanType;
import org.apache.tsfile.read.common.type.DoubleType;
import org.apache.tsfile.read.common.type.FloatType;
import org.apache.tsfile.read.common.type.IntType;
import org.apache.tsfile.read.common.type.LongType;
import org.apache.tsfile.read.common.type.StringType;
import org.apache.tsfile.read.common.type.TimestampType;
import org.apache.tsfile.read.common.type.Type;

public class PatternExpressionComputation {
    private final List<PhysicalValueAccessor> valueAccessors;
    private final Computation computation;
    private final PatternAggregator[] patternAggregators;

    public PatternExpressionComputation(List<PhysicalValueAccessor> valueAccessors, Computation computation, List<PatternAggregator> patternAggregators) {
        this.valueAccessors = valueAccessors;
        this.computation = computation;
        this.patternAggregators = patternAggregators.toArray(new PatternAggregator[0]);
    }

    public Object compute(int currentRow, ArrayView matchedLabels, PatternAggregator[] patternAggregators, int partitionStart, int searchStart, int searchEnd, int patternStart, long matchNumber, List<String> labelNames, Partition partition) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (PhysicalValueAccessor accessor : this.valueAccessors) {
            if (accessor instanceof PhysicalValuePointer) {
                PhysicalValuePointer pointer = (PhysicalValuePointer)accessor;
                int channel = pointer.getSourceChannel();
                if (channel == -2) {
                    values.add(matchNumber);
                    continue;
                }
                int position = pointer.getLogicalIndexNavigation().resolvePosition(currentRow, matchedLabels, searchStart, searchEnd, patternStart);
                if (position >= 0) {
                    if (channel == -1) {
                        TSDataType type = TSDataType.STRING;
                        if (position < patternStart || position >= patternStart + matchedLabels.length()) {
                            values.add(null);
                            continue;
                        }
                        values.add(labelNames.get(matchedLabels.get(position - patternStart)));
                        continue;
                    }
                    values.add(this.getValueFromPartition(partition, pointer, position - partitionStart));
                    continue;
                }
                values.add(null);
                continue;
            }
            if (!(accessor instanceof PhysicalAggregationPointer)) continue;
            PatternAggregator aggregator = patternAggregators[((PhysicalAggregationPointer)accessor).getIndex()];
            values.add(aggregator.aggregate(currentRow, matchedLabels, partition, partitionStart, patternStart));
        }
        return this.computation.evaluate(values);
    }

    public Object computeEmpty(long matchNumber) {
        ArrayList<Long> values = new ArrayList<Long>();
        for (PhysicalValueAccessor accessor : this.valueAccessors) {
            PhysicalValuePointer pointer;
            int channel;
            if (!(accessor instanceof PhysicalValuePointer) || (channel = (pointer = (PhysicalValuePointer)accessor).getSourceChannel()) != -2) continue;
            values.add(matchNumber);
        }
        if (!values.isEmpty()) {
            return matchNumber;
        }
        return null;
    }

    private Object getValueFromPartition(Partition partition, PhysicalValuePointer pointer, int position) {
        int channel = pointer.getSourceChannel();
        Type type = pointer.getType();
        if (type instanceof BooleanType) {
            return partition.getBoolean(channel, position);
        }
        if (type instanceof IntType) {
            return partition.getInt(channel, position);
        }
        if (type instanceof LongType || type instanceof TimestampType) {
            return partition.getLong(channel, position);
        }
        if (type instanceof FloatType) {
            return Float.valueOf(partition.getFloat(channel, position));
        }
        if (type instanceof DoubleType) {
            return partition.getDouble(channel, position);
        }
        if (type instanceof StringType) {
            return partition.getBinary(channel, position);
        }
        throw new SemanticException("Unsupported type: " + type.getClass().getSimpleName());
    }
}

