/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.control;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.LongConsumer;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileID;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.read.UnClosedTsFileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileReaderManager {
    private static final Logger logger = LoggerFactory.getLogger(FileReaderManager.class);
    private static final Logger resourceLogger = LoggerFactory.getLogger((String)"FileMonitor");
    private static final Logger DEBUG_LOGGER = LoggerFactory.getLogger((String)"QUERY_DEBUG");
    private static final int MAX_CACHED_FILE_SIZE = 30000;
    private static final int PRINT_INTERVAL = 10000;
    private Map<TsFileID, TsFileSequenceReader> closedFileReaderMap = new ConcurrentHashMap<TsFileID, TsFileSequenceReader>();
    private Map<TsFileID, TsFileSequenceReader> unclosedFileReaderMap = new ConcurrentHashMap<TsFileID, TsFileSequenceReader>();
    private Map<TsFileID, AtomicInteger> closedReferenceMap = new ConcurrentHashMap<TsFileID, AtomicInteger>();
    private Map<TsFileID, AtomicInteger> unclosedReferenceMap = new ConcurrentHashMap<TsFileID, AtomicInteger>();

    private FileReaderManager() {
    }

    public static FileReaderManager getInstance() {
        return FileReaderManagerHelper.INSTANCE;
    }

    public synchronized void closeFileAndRemoveReader(TsFileID tsFileID) throws IOException {
        this.closedReferenceMap.remove(tsFileID);
        TsFileSequenceReader reader = this.closedFileReaderMap.remove(tsFileID);
        if (reader != null) {
            reader.close();
        }
        this.unclosedReferenceMap.remove(tsFileID);
        reader = this.unclosedFileReaderMap.remove(tsFileID);
        if (reader != null) {
            reader.close();
        }
    }

    public synchronized TsFileSequenceReader get(String filePath, TsFileID tsFileID, boolean isClosed) throws IOException {
        return this.get(filePath, tsFileID, isClosed, null);
    }

    public synchronized TsFileSequenceReader get(String filePath, TsFileID tsFileID, boolean isClosed, LongConsumer ioSizeRecorder) throws IOException {
        Map<TsFileID, TsFileSequenceReader> readerMap;
        Map<TsFileID, TsFileSequenceReader> map = readerMap = !isClosed ? this.unclosedFileReaderMap : this.closedFileReaderMap;
        if (!readerMap.containsKey(tsFileID)) {
            int currentOpenedReaderCount = readerMap.size();
            if (currentOpenedReaderCount >= 30000 && currentOpenedReaderCount % 10000 == 0) {
                logger.warn("Query has opened {} files !", (Object)readerMap.size());
            }
            UnClosedTsFileReader tsFileReader = null;
            if (!isClosed) {
                tsFileReader = new UnClosedTsFileReader(filePath, ioSizeRecorder);
            } else {
                tsFileReader = new TsFileSequenceReader(filePath, ioSizeRecorder);
                byte versionNumber = tsFileReader.readVersionNumber();
                if (versionNumber != 3) {
                    tsFileReader.close();
                    throw new IOException(String.format("The version of TsFile %s is not correct: %s", filePath, versionNumber));
                }
            }
            readerMap.put(tsFileID, (TsFileSequenceReader)tsFileReader);
            return tsFileReader;
        }
        return readerMap.get(tsFileID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseFileReaderReference(TsFileResource tsFile, boolean isClosed) {
        tsFile.readLock();
        FileReaderManager fileReaderManager = this;
        synchronized (fileReaderManager) {
            if (!isClosed) {
                this.unclosedReferenceMap.computeIfAbsent(tsFile.getTsFileID(), k -> new AtomicInteger()).getAndIncrement();
            } else {
                this.closedReferenceMap.computeIfAbsent(tsFile.getTsFileID(), k -> new AtomicInteger()).getAndIncrement();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decreaseFileReaderReference(TsFileResource tsFile, boolean isClosed) {
        FileReaderManager fileReaderManager = this;
        synchronized (fileReaderManager) {
            if (!isClosed && this.unclosedReferenceMap.containsKey(tsFile.getTsFileID())) {
                if (this.unclosedReferenceMap.get(tsFile.getTsFileID()).decrementAndGet() == 0) {
                    this.closeUnUsedReaderAndRemoveRef(tsFile.getTsFilePath(), tsFile.getTsFileID(), false);
                }
            } else if (this.closedReferenceMap.containsKey(tsFile.getTsFileID()) && this.closedReferenceMap.get(tsFile.getTsFileID()).decrementAndGet() == 0) {
                this.closeUnUsedReaderAndRemoveRef(tsFile.getTsFilePath(), tsFile.getTsFileID(), true);
            }
        }
        tsFile.readUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeUnUsedReaderAndRemoveRef(String tsFilePath, TsFileID tsFileID, boolean isClosed) {
        Map<TsFileID, TsFileSequenceReader> readerMap = isClosed ? this.closedFileReaderMap : this.unclosedFileReaderMap;
        Map<TsFileID, AtomicInteger> refMap = isClosed ? this.closedReferenceMap : this.unclosedReferenceMap;
        FileReaderManager fileReaderManager = this;
        synchronized (fileReaderManager) {
            if (refMap.get(tsFileID).get() != 0) {
                return;
            }
            TsFileSequenceReader reader = readerMap.get(tsFileID);
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.error("Can not close TsFileSequenceReader {} !", (Object)reader.getFileName(), (Object)e);
                }
            }
            readerMap.remove(tsFileID);
            refMap.remove(tsFileID);
            if (resourceLogger.isDebugEnabled()) {
                resourceLogger.debug("{} TsFileReader is closed because of no reference.", (Object)tsFilePath);
            }
        }
    }

    public synchronized void closeAndRemoveAllOpenedReaders() throws IOException {
        Map.Entry<TsFileID, TsFileSequenceReader> entry;
        Iterator<Map.Entry<TsFileID, TsFileSequenceReader>> iterator = this.closedFileReaderMap.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            entry.getValue().close();
            if (resourceLogger.isDebugEnabled()) {
                resourceLogger.debug("{} closedTsFileReader is closed.", (Object)entry.getKey());
            }
            this.closedReferenceMap.remove(entry.getKey());
            iterator.remove();
        }
        iterator = this.unclosedFileReaderMap.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            entry.getValue().close();
            if (resourceLogger.isDebugEnabled()) {
                resourceLogger.debug("{} unclosedTsFileReader is closed.", (Object)entry.getKey());
            }
            this.unclosedReferenceMap.remove(entry.getKey());
            iterator.remove();
        }
    }

    public synchronized boolean contains(TsFileResource tsFile, boolean isClosed) {
        return isClosed && this.closedFileReaderMap.containsKey(tsFile.getTsFileID()) || !isClosed && this.unclosedFileReaderMap.containsKey(tsFile.getTsFileID());
    }

    public Map<TsFileID, TsFileSequenceReader> getClosedFileReaderMap() {
        return this.closedFileReaderMap;
    }

    public Map<TsFileID, TsFileSequenceReader> getUnclosedFileReaderMap() {
        return this.unclosedFileReaderMap;
    }

    private static class FileReaderManagerHelper {
        private static final FileReaderManager INSTANCE = new FileReaderManager();

        private FileReaderManagerHelper() {
        }
    }
}

