/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.extractor.dataregion.realtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeNonCriticalException;
import org.apache.iotdb.commons.pipe.agent.task.connection.UnboundedBlockingPendingQueue;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.config.plugin.env.PipeTaskExtractorRuntimeEnvironment;
import org.apache.iotdb.commons.pipe.datastructure.pattern.PipePattern;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.event.ProgressReportEvent;
import org.apache.iotdb.commons.pipe.metric.PipeEventCounter;
import org.apache.iotdb.commons.utils.TimePartitionUtils;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.pipe.event.realtime.PipeRealtimeEvent;
import org.apache.iotdb.db.pipe.extractor.dataregion.DataRegionListeningFilter;
import org.apache.iotdb.db.pipe.extractor.dataregion.realtime.assigner.PipeTsFileEpochProgressIndexKeeper;
import org.apache.iotdb.db.pipe.extractor.dataregion.realtime.listener.PipeInsertionDataNodeListener;
import org.apache.iotdb.db.pipe.extractor.dataregion.realtime.listener.PipeTimePartitionListener;
import org.apache.iotdb.db.pipe.metric.source.PipeDataRegionEventCounter;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.iotdb.pipe.api.PipeExtractor;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeExtractorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.exception.PipeParameterNotValidException;
import org.apache.tsfile.utils.Pair;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipeRealtimeDataRegionExtractor
implements PipeExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeRealtimeDataRegionExtractor.class);
    protected String pipeName;
    protected long creationTime;
    protected String dataRegionId;
    protected PipeTaskMeta pipeTaskMeta;
    protected boolean shouldExtractInsertion;
    protected boolean shouldExtractDeletion;
    protected PipePattern pipePattern;
    private boolean isDbNameCoveredByPattern = false;
    protected long realtimeDataExtractionStartTime = Long.MIN_VALUE;
    protected long realtimeDataExtractionEndTime = Long.MAX_VALUE;
    private boolean disableCheckingDataRegionTimePartitionCovering = false;
    private long startTimePartitionIdLowerBound;
    private long endTimePartitionIdUpperBound;
    private final AtomicReference<Pair<Long, Long>> dataRegionTimePartitionIdBound = new AtomicReference();
    protected boolean isForwardingPipeRequests = true;
    private boolean shouldTransferModFile;
    private boolean sloppyTimeRange;
    private boolean sloppyPattern;
    protected final UnboundedBlockingPendingQueue<Event> pendingQueue = new UnboundedBlockingPendingQueue((PipeEventCounter)new PipeDataRegionEventCounter());
    protected final AtomicBoolean isClosed = new AtomicBoolean(false);
    protected String pipeID;
    private String taskID;

    protected PipeRealtimeDataRegionExtractor() {
    }

    public void validate(PipeParameterValidator validator) throws Exception {
        PipeParameters parameters = validator.getParameters();
        try {
            this.realtimeDataExtractionStartTime = parameters.hasAnyAttributes(new String[]{"source.start-time", "extractor.start-time"}) ? DateTimeUtils.convertTimestampOrDatetimeStrToLongWithDefaultZone(parameters.getStringByKeys(new String[]{"source.start-time", "extractor.start-time"})) : Long.MIN_VALUE;
            long l = this.realtimeDataExtractionEndTime = parameters.hasAnyAttributes(new String[]{"source.end-time", "extractor.end-time"}) ? DateTimeUtils.convertTimestampOrDatetimeStrToLongWithDefaultZone(parameters.getStringByKeys(new String[]{"source.end-time", "extractor.end-time"})) : Long.MAX_VALUE;
            if (this.realtimeDataExtractionStartTime > this.realtimeDataExtractionEndTime) {
                throw new PipeParameterNotValidException(String.format("%s (%s) [%s] should be less than or equal to %s (%s) [%s].", "source.start-time", "extractor.start-time", this.realtimeDataExtractionStartTime, "source.end-time", "extractor.end-time", this.realtimeDataExtractionEndTime));
            }
        }
        catch (PipeParameterNotValidException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PipeParameterNotValidException(e.getMessage());
        }
        String extractorRealtimeLooseRangeValue = parameters.getStringOrDefault(Arrays.asList("extractor.realtime.loose-range", "source.realtime.loose-range"), "").trim();
        if ("all".equalsIgnoreCase(extractorRealtimeLooseRangeValue)) {
            this.sloppyTimeRange = true;
            this.sloppyPattern = true;
        } else {
            Set sloppyOptionSet = Arrays.stream(extractorRealtimeLooseRangeValue.split(",")).map(String::trim).filter(s -> !s.isEmpty()).map(String::toLowerCase).collect(Collectors.toSet());
            this.sloppyTimeRange = sloppyOptionSet.remove("time");
            this.sloppyPattern = sloppyOptionSet.remove("path");
            if (!sloppyOptionSet.isEmpty()) {
                throw new PipeParameterNotValidException(String.format("Parameters in set %s are not allowed in 'realtime.loose-range'", sloppyOptionSet));
            }
        }
    }

    public void customize(PipeParameters parameters, PipeExtractorRuntimeConfiguration configuration) throws Exception {
        String databaseName;
        PipeTaskExtractorRuntimeEnvironment environment = (PipeTaskExtractorRuntimeEnvironment)configuration.getRuntimeEnvironment();
        Pair<Boolean, Boolean> insertionDeletionListeningOptionPair = DataRegionListeningFilter.parseInsertionDeletionListeningOptionPair(parameters);
        this.shouldExtractInsertion = (Boolean)insertionDeletionListeningOptionPair.getLeft();
        this.shouldExtractDeletion = (Boolean)insertionDeletionListeningOptionPair.getRight();
        this.pipeName = environment.getPipeName();
        this.dataRegionId = String.valueOf(environment.getRegionId());
        this.pipeTaskMeta = environment.getPipeTaskMeta();
        this.creationTime = environment.getCreationTime();
        this.pipeID = this.pipeName + "_" + this.creationTime;
        this.taskID = this.pipeName + "_" + this.dataRegionId + "_" + this.creationTime;
        this.pipePattern = PipePattern.parsePipePatternFromSourceParameters((PipeParameters)parameters);
        DataRegion dataRegion = StorageEngine.getInstance().getDataRegion(new DataRegionId(environment.getRegionId()));
        if (dataRegion != null && (databaseName = dataRegion.getDatabaseName()) != null) {
            this.isDbNameCoveredByPattern = this.pipePattern.coversDb(databaseName);
        }
        this.startTimePartitionIdLowerBound = this.realtimeDataExtractionStartTime % TimePartitionUtils.getTimePartitionInterval() == 0L ? TimePartitionUtils.getTimePartitionId((long)this.realtimeDataExtractionStartTime) : TimePartitionUtils.getTimePartitionId((long)this.realtimeDataExtractionStartTime) + 1L;
        this.endTimePartitionIdUpperBound = this.realtimeDataExtractionEndTime % TimePartitionUtils.getTimePartitionInterval() == 0L ? TimePartitionUtils.getTimePartitionId((long)this.realtimeDataExtractionEndTime) : TimePartitionUtils.getTimePartitionId((long)this.realtimeDataExtractionEndTime) - 1L;
        this.isForwardingPipeRequests = true;
        this.shouldTransferModFile = parameters.getBooleanOrDefault(Arrays.asList("source.mods.enable", "extractor.mods.enable"), this.shouldExtractDeletion);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Pipe {}@{}: realtime data region extractor is initialized with parameters: {}.", new Object[]{this.pipeName, this.dataRegionId, parameters});
        }
    }

    public void start() throws Exception {
        PipeTimePartitionListener.getInstance().startListen(this.dataRegionId, this);
        PipeInsertionDataNodeListener.getInstance().startListenAndAssign(this.dataRegionId, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        if (Objects.nonNull(this.dataRegionId)) {
            PipeInsertionDataNodeListener.getInstance().stopListenAndAssign(this.dataRegionId, this);
            PipeTimePartitionListener.getInstance().stopListen(this.dataRegionId, this);
        }
        AtomicBoolean atomicBoolean = this.isClosed;
        synchronized (atomicBoolean) {
            this.clearPendingQueue();
            this.isClosed.set(true);
        }
    }

    private void clearPendingQueue() {
        ArrayList eventsToDrop = new ArrayList(this.pendingQueue.size());
        this.pendingQueue.forEach(eventsToDrop::add);
        this.pendingQueue.clear();
        eventsToDrop.forEach(event -> {
            if (event instanceof EnrichedEvent) {
                ((EnrichedEvent)event).clearReferenceCount(PipeRealtimeDataRegionExtractor.class.getName());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void extract(PipeRealtimeEvent event) {
        if (event.getEvent() instanceof ProgressReportEvent) {
            this.extractDirectly(event);
            return;
        }
        if (this.isDbNameCoveredByPattern) {
            event.skipParsingPattern();
        }
        if (!this.disableCheckingDataRegionTimePartitionCovering && Objects.nonNull(this.dataRegionTimePartitionIdBound.get())) {
            if (this.isDataRegionTimePartitionCoveredByTimeRange()) {
                event.skipParsingTime();
            } else {
                this.disableCheckingDataRegionTimePartitionCovering = true;
            }
        }
        if (!(event.shouldParseTime() && !event.getEvent().mayEventTimeOverlappedWithTimeRange() || event.shouldParsePattern() && !event.getEvent().mayEventPathsOverlappedWithPattern())) {
            if (this.sloppyTimeRange) {
                event.skipParsingTime();
            }
            if (this.sloppyPattern) {
                event.skipParsingPattern();
            }
            this.doExtract(event);
        } else {
            event.decreaseReferenceCount(PipeRealtimeDataRegionExtractor.class.getName(), false);
        }
        AtomicBoolean atomicBoolean = this.isClosed;
        synchronized (atomicBoolean) {
            if (this.isClosed.get()) {
                this.clearPendingQueue();
            }
        }
    }

    protected abstract void doExtract(PipeRealtimeEvent var1);

    protected void extractHeartbeat(PipeRealtimeEvent event) {
        ((PipeHeartbeatEvent)event.getEvent()).recordExtractorQueueSize(this.pendingQueue);
        Event lastEvent = this.pendingQueue.peekLast();
        if (lastEvent instanceof PipeRealtimeEvent && ((PipeRealtimeEvent)lastEvent).getEvent() instanceof PipeHeartbeatEvent && (((PipeHeartbeatEvent)((PipeRealtimeEvent)lastEvent).getEvent()).isShouldPrintMessage() || !((PipeHeartbeatEvent)event.getEvent()).isShouldPrintMessage())) {
            event.decreaseReferenceCount(PipeRealtimeDataRegionExtractor.class.getName(), false);
            return;
        }
        if (!this.pendingQueue.waitedOffer((Event)event)) {
            LOGGER.error("extract: pending queue of PipeRealtimeDataRegionHybridExtractor {} has reached capacity, discard heartbeat event {}", (Object)this, (Object)event);
            event.decreaseReferenceCount(PipeRealtimeDataRegionExtractor.class.getName(), false);
        }
    }

    protected void extractDirectly(PipeRealtimeEvent event) {
        if (!this.pendingQueue.waitedOffer((Event)event)) {
            String errorMessage = String.format("extract: pending queue of %s %s has reached capacity, discard event %s", new Object[]{this.getClass().getSimpleName(), this, event});
            LOGGER.error(errorMessage);
            PipeDataNodeAgent.runtime().report(this.pipeTaskMeta, (PipeRuntimeException)new PipeRuntimeNonCriticalException(errorMessage));
            event.decreaseReferenceCount(PipeRealtimeDataRegionExtractor.class.getName(), false);
        }
    }

    protected void maySkipIndex4Event(PipeRealtimeEvent event) {
        if (event.getEvent() instanceof PipeTsFileInsertionEvent || event.getEvent() instanceof PipeInsertNodeTabletInsertionEvent) {
            this.maySkipProgressIndexForRealtimeEvent(event);
        }
    }

    protected Event supplyHeartbeat(PipeRealtimeEvent event) {
        if (event.increaseReferenceCount(PipeRealtimeDataRegionExtractor.class.getName())) {
            return event.getEvent();
        }
        LOGGER.error("Heartbeat Event {} can not be supplied because the reference count can not be increased", (Object)event.getEvent());
        return null;
    }

    protected Event supplyDirectly(PipeRealtimeEvent event) {
        if (event.increaseReferenceCount(PipeRealtimeDataRegionExtractor.class.getName())) {
            return event.getEvent();
        }
        String errorMessage = String.format("Event %s can not be supplied because the reference count can not be increased, the data represented by this event is lost", event.getEvent());
        LOGGER.error(errorMessage);
        PipeDataNodeAgent.runtime().report(this.pipeTaskMeta, (PipeRuntimeException)new PipeRuntimeNonCriticalException(errorMessage));
        return null;
    }

    public final String getPipeName() {
        return this.pipeName;
    }

    public final long getCreationTime() {
        return this.creationTime;
    }

    public final PipeTaskMeta getPipeTaskMeta() {
        return this.pipeTaskMeta;
    }

    public final boolean shouldExtractInsertion() {
        return this.shouldExtractInsertion;
    }

    public final boolean shouldExtractDeletion() {
        return this.shouldExtractDeletion;
    }

    public final String getPatternString() {
        return this.pipePattern != null ? this.pipePattern.getPattern() : null;
    }

    public final PipePattern getPipePattern() {
        return this.pipePattern;
    }

    public final long getRealtimeDataExtractionStartTime() {
        return this.realtimeDataExtractionStartTime;
    }

    public final long getRealtimeDataExtractionEndTime() {
        return this.realtimeDataExtractionEndTime;
    }

    public void setDataRegionTimePartitionIdBound(@NonNull Pair<Long, Long> timePartitionIdBound) {
        LOGGER.info("PipeRealtimeDataRegionExtractor({}) observed data region {} time partition growth, recording time partition id bound: {}.", new Object[]{this.taskID, this.dataRegionId, timePartitionIdBound});
        this.dataRegionTimePartitionIdBound.set(timePartitionIdBound);
    }

    private boolean isDataRegionTimePartitionCoveredByTimeRange() {
        Pair<Long, Long> timePartitionIdBound = this.dataRegionTimePartitionIdBound.get();
        return this.startTimePartitionIdLowerBound <= (Long)timePartitionIdBound.left && (Long)timePartitionIdBound.right <= this.endTimePartitionIdUpperBound;
    }

    public final boolean isForwardingPipeRequests() {
        return this.isForwardingPipeRequests;
    }

    public abstract boolean isNeedListenToTsFile();

    public abstract boolean isNeedListenToInsertNode();

    public final boolean isShouldTransferModFile() {
        return this.shouldTransferModFile;
    }

    private void maySkipProgressIndexForRealtimeEvent(PipeRealtimeEvent event) {
        if (PipeTsFileEpochProgressIndexKeeper.getInstance().isProgressIndexAfterOrEquals(this.dataRegionId, this.pipeName, event.getTsFileEpoch().getFilePath(), this.getProgressIndex4RealtimeEvent(event))) {
            event.skipReportOnCommit();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Pipe {} on data region {} skip commit of event {} because it was flushed prematurely.", new Object[]{this.pipeName, this.dataRegionId, event.coreReportMessage()});
            }
        }
    }

    private ProgressIndex getProgressIndex4RealtimeEvent(PipeRealtimeEvent event) {
        return event.getEvent() instanceof PipeTsFileInsertionEvent ? ((PipeTsFileInsertionEvent)event.getEvent()).forceGetProgressIndex() : event.getProgressIndex();
    }

    public String toString() {
        return "PipeRealtimeDataRegionExtractor{pipePattern='" + this.pipePattern + '\'' + ", dataRegionId='" + this.dataRegionId + '\'' + '}';
    }

    public int getTabletInsertionEventCount() {
        return this.pendingQueue.getTabletInsertionEventCount();
    }

    public int getTsFileInsertionEventCount() {
        return this.pendingQueue.getTsFileInsertionEventCount();
    }

    public int getPipeHeartbeatEventCount() {
        return this.pendingQueue.getPipeHeartbeatEventCount();
    }

    public int getEventCount() {
        return this.pendingQueue.size();
    }

    public String getTaskID() {
        return this.taskID;
    }
}

