/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.agent;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.commons.subscription.config.SubscriptionConfig;
import org.apache.iotdb.db.subscription.agent.SubscriptionAgentLauncher;
import org.apache.iotdb.db.subscription.agent.SubscriptionBrokerAgent;
import org.apache.iotdb.db.subscription.agent.SubscriptionConsumerAgent;
import org.apache.iotdb.db.subscription.agent.SubscriptionTopicAgent;

public class SubscriptionRuntimeAgent
implements IService {
    private final SubscriptionConsumerAgent consumerAgent;
    private final SubscriptionBrokerAgent brokerAgent;
    private final SubscriptionTopicAgent topicAgent;
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);

    SubscriptionRuntimeAgent() {
        this.consumerAgent = new SubscriptionConsumerAgent();
        this.brokerAgent = new SubscriptionBrokerAgent();
        this.topicAgent = new SubscriptionTopicAgent();
    }

    SubscriptionConsumerAgent consumer() {
        return this.consumerAgent;
    }

    SubscriptionBrokerAgent broker() {
        return this.brokerAgent;
    }

    SubscriptionTopicAgent topic() {
        return this.topicAgent;
    }

    public void start() throws StartupException {
        SubscriptionConfig.getInstance().printAllConfigs();
        SubscriptionAgentLauncher.launchSubscriptionTopicAgent();
        SubscriptionAgentLauncher.launchSubscriptionConsumerAgent();
        this.isShutdown.set(false);
    }

    public void stop() {
        if (this.isShutdown.get()) {
            return;
        }
        this.isShutdown.set(true);
    }

    public boolean isShutdown() {
        return this.isShutdown.get();
    }

    public ServiceType getID() {
        return ServiceType.SUBSCRIPTION_RUNTIME_AGENT;
    }
}

