/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.lock;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.plan.analyze.lock.SchemaLockType;

public class DataNodeSchemaLockManager {
    private final ReentrantReadWriteLock[] locks;

    public static DataNodeSchemaLockManager getInstance() {
        return DataNodeSchemaLockManagerHold.INSTANCE;
    }

    private DataNodeSchemaLockManager() {
        int lockNum = SchemaLockType.values().length;
        this.locks = new ReentrantReadWriteLock[lockNum];
        for (int i = 0; i < lockNum; ++i) {
            this.locks[i] = new ReentrantReadWriteLock(false);
        }
    }

    public void takeReadLock(MPPQueryContext context, SchemaLockType lockType) {
        if (context.addAcquiredLock(lockType)) {
            this.locks[lockType.ordinal()].readLock().lock();
        }
    }

    public void releaseReadLock(MPPQueryContext queryContext) {
        if (queryContext != null && !queryContext.getAcquiredLocks().isEmpty()) {
            queryContext.getAcquiredLocks().forEach(lockType -> this.locks[lockType.ordinal()].readLock().unlock());
        }
    }

    public void takeWriteLock(SchemaLockType lockType) {
        this.locks[lockType.ordinal()].writeLock().lock();
    }

    public void releaseWriteLock(SchemaLockType lockType) {
        this.locks[lockType.ordinal()].writeLock().unlock();
    }

    private static class DataNodeSchemaLockManagerHold {
        private static final DataNodeSchemaLockManager INSTANCE = new DataNodeSchemaLockManager();

        private DataNodeSchemaLockManagerHold() {
        }
    }
}

