/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session.subscription.util;

public class PollTimer {
    private long startMs;
    private long currentTimeMs;
    private long deadlineMs;
    private long timeoutMs;

    public PollTimer(long startMs, long timeoutMs) {
        this.update(startMs);
        this.reset(timeoutMs);
    }

    public boolean isExpired() {
        return this.currentTimeMs >= this.deadlineMs;
    }

    public boolean isExpired(long deltaMs) {
        return this.currentTimeMs >= this.deadlineMs - Math.max(deltaMs, 0L);
    }

    public boolean notExpired() {
        return !this.isExpired();
    }

    public boolean notExpired(long deltaMs) {
        return !this.isExpired(deltaMs);
    }

    public void reset(long timeoutMs) {
        if (timeoutMs < 0L) {
            throw new IllegalArgumentException("Invalid negative timeout " + timeoutMs);
        }
        this.timeoutMs = timeoutMs;
        this.startMs = this.currentTimeMs;
        this.deadlineMs = this.currentTimeMs > Long.MAX_VALUE - timeoutMs ? Long.MAX_VALUE : this.currentTimeMs + timeoutMs;
    }

    public void update() {
        this.update(System.currentTimeMillis());
    }

    public void update(long currentTimeMs) {
        this.currentTimeMs = Math.max(currentTimeMs, this.currentTimeMs);
    }

    public long remainingMs() {
        return Math.max(0L, this.deadlineMs - this.currentTimeMs);
    }

    public long currentTimeMs() {
        return this.currentTimeMs;
    }

    public long elapsedMs() {
        return this.currentTimeMs - this.startMs;
    }

    public long timeoutMs() {
        return this.timeoutMs;
    }
}

