/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.agent.task.progress;

import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.pipe.agent.task.progress.CommitterKey;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeEventCommitter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeEventCommitter.class);
    private final CommitterKey committerKey;
    private final AtomicLong commitIdGenerator = new AtomicLong(0L);
    private final AtomicLong lastCommitId = new AtomicLong(0L);
    private final PriorityBlockingQueue<EnrichedEvent> commitQueue = new PriorityBlockingQueue<EnrichedEvent>(11, Comparator.comparing(event -> Objects.requireNonNull(event, "committable event cannot be null").getCommitId()));

    PipeEventCommitter(CommitterKey committerKey) {
        this.committerKey = committerKey;
    }

    public synchronized long generateCommitId() {
        return this.commitIdGenerator.incrementAndGet();
    }

    public synchronized void commit(EnrichedEvent event) {
        this.commitQueue.offer(event);
        int commitQueueSizeBeforeCommit = this.commitQueue.size();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("COMMIT QUEUE OFFER: committer key {}, event commit id {}, last commit id {}, commit queue size {}", new Object[]{this.committerKey, event.getCommitId(), this.lastCommitId.get(), commitQueueSizeBeforeCommit});
        } else if (commitQueueSizeBeforeCommit != 0 && commitQueueSizeBeforeCommit % 100 == 0) {
            LOGGER.info("COMMIT QUEUE OFFER: committer key {}, event commit id {}, last commit id {}, commit queue size {}", new Object[]{this.committerKey, event.getCommitId(), this.lastCommitId.get(), commitQueueSizeBeforeCommit});
        }
        while (!this.commitQueue.isEmpty()) {
            EnrichedEvent e = this.commitQueue.peek();
            if (e.getCommitId() <= this.lastCommitId.get()) {
                LOGGER.warn("commit id must be monotonically increasing, current commit id: {}, last commit id: {}, event: {}, stack trace: {}", new Object[]{e.getCommitId(), this.lastCommitId.get(), e.coreReportMessage(), Thread.currentThread().getStackTrace()});
                this.commitQueue.poll();
                continue;
            }
            if (e.getCommitId() != this.lastCommitId.get() + 1L) break;
            e.onCommitted();
            this.lastCommitId.incrementAndGet();
            this.commitQueue.poll();
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("COMMIT QUEUE POLL: committer key {}, last commit id {}, commit queue size after commit {}", new Object[]{this.committerKey, this.lastCommitId.get(), this.commitQueue.size()});
        }
    }

    public String getPipeName() {
        return this.committerKey.getPipeName();
    }

    public long getCreationTime() {
        return this.committerKey.getCreationTime();
    }

    public int getRegionId() {
        return this.committerKey.getRegionId();
    }

    public long commitQueueSize() {
        return this.commitQueue.size();
    }

    public long getCurrentCommitId() {
        return this.commitIdGenerator.get();
    }
}

