/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.resolver.AddressResolverGroup;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.http.client.Http2ConnectionProvider;
import reactor.netty.http.client.HttpClientConfig;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.transport.TransportConfig;
import reactor.util.annotation.Nullable;

final class HttpConnectionProvider
implements ConnectionProvider {
    final ConnectionProvider http1ConnectionProvider;
    final Supplier<ConnectionProvider> h2ConnectionProviderSupplier;
    static final AtomicReference<ConnectionProvider> h2ConnectionProvider = new AtomicReference();

    public Mono<? extends Connection> acquire(TransportConfig config, ConnectionObserver connectionObserver, @Nullable Supplier<? extends SocketAddress> remoteAddress, @Nullable AddressResolverGroup<?> resolverGroup) {
        if (((HttpClientConfig)config)._protocols == 4) {
            return this.http1ConnectionProvider.acquire(config, connectionObserver, remoteAddress, resolverGroup);
        }
        return this.h2ConnectionProviderSupplier.get().acquire(config, connectionObserver, remoteAddress, resolverGroup);
    }

    public void disposeWhen(SocketAddress address) {
        this.http1ConnectionProvider.disposeWhen(address);
    }

    HttpConnectionProvider(ConnectionProvider http1ConnectionProvider) {
        this(http1ConnectionProvider, () -> HttpConnectionProvider.getOrCreate(http1ConnectionProvider));
    }

    HttpConnectionProvider(ConnectionProvider http1ConnectionProvider, Supplier<ConnectionProvider> h2ConnectionProviderSupplier) {
        this.http1ConnectionProvider = http1ConnectionProvider;
        this.h2ConnectionProviderSupplier = h2ConnectionProviderSupplier;
    }

    static ConnectionProvider getOrCreate(ConnectionProvider http1ConnectionProvider) {
        ConnectionProvider provider = h2ConnectionProvider.get();
        if (provider == null) {
            ConnectionProvider.Builder builder = (ConnectionProvider.Builder)((ConnectionProvider.Builder)ConnectionProvider.builder((String)"http2").maxConnections(http1ConnectionProvider.maxConnections())).pendingAcquireMaxCount(-1);
            if (http1ConnectionProvider.maxConnectionsPerHost() != null) {
                http1ConnectionProvider.maxConnectionsPerHost().forEach((address, maxConn) -> builder.forRemoteHost(address, spec -> {
                    ConnectionProvider.HostSpecificSpec cfr_ignored_0 = (ConnectionProvider.HostSpecificSpec)spec.maxConnections(maxConn.intValue());
                }));
            }
            h2ConnectionProvider.compareAndSet(null, (ConnectionProvider)new Http2ConnectionProvider(http1ConnectionProvider, builder));
            provider = HttpConnectionProvider.getOrCreate(http1ConnectionProvider);
        }
        return provider;
    }
}

