/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.windowing.configuration;

import org.apache.iotdb.db.utils.windowing.configuration.Configuration;
import org.apache.iotdb.db.utils.windowing.exception.WindowingException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class SlidingSizeWindowConfiguration
extends Configuration {
    private final int windowSize;
    private final int slidingStep;

    public SlidingSizeWindowConfiguration(TSDataType dataType, int windowSize, int slidingStep) {
        super(dataType);
        this.windowSize = windowSize;
        this.slidingStep = slidingStep;
    }

    public SlidingSizeWindowConfiguration(TSDataType dataType, int windowSize) {
        super(dataType);
        this.windowSize = windowSize;
        this.slidingStep = windowSize;
    }

    @Override
    public void check() throws WindowingException {
        if (this.windowSize <= 0) {
            throw new WindowingException(String.format("Parameter windowSize(%d) should be positive.", this.windowSize));
        }
        if (this.slidingStep <= 0) {
            throw new WindowingException(String.format("Parameter slidingStep(%d) should be positive.", this.slidingStep));
        }
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public int getSlidingStep() {
        return this.slidingStep;
    }
}

