/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.virtualsg;

import java.util.Set;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.storagegroup.virtualSg.HashVirtualPartitioner;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.metadata.path.PartialPath;

public class DeviceMappingViewer {
    public static void main(String[] args) throws MetadataException {
        if (args.length == 1) {
            IoTDBDescriptor.getInstance().getConfig().setSchemaDir(args[0]);
        }
        HashVirtualPartitioner partitioner = HashVirtualPartitioner.getInstance();
        IoTDBDescriptor.getInstance().getConfig().setEnableMTreeSnapshot(false);
        MManager mManager = MManager.getInstance();
        mManager.init();
        Set<PartialPath> partialPathSet = mManager.getMatchedDevices(new PartialPath("root.**"), false);
        if (partialPathSet.isEmpty() && args.length == 1) {
            System.out.println("no mlog in given system schema dir: " + args[0] + " please have a check");
        } else {
            System.out.println();
            System.out.println("--------------------- mapping from device to virtual storage group ID ---------------------");
            System.out.println("Format is: device name -> virtual storage group ID");
            for (PartialPath partialPath : partialPathSet) {
                System.out.println(partialPath + " -> " + partitioner.deviceToVirtualStorageGroupId(partialPath));
            }
        }
        mManager.clear();
    }
}

