/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.settle;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.engine.settle.SettleLog;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceStatus;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.tools.TsFileRewriteTool;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.fileSystem.fsFactory.FSFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileAndModSettleTool {
    private static final Logger logger = LoggerFactory.getLogger(TsFileAndModSettleTool.class);
    public Map<String, Integer> recoverSettleFileMap = new HashMap<String, Integer>();
    private static final TsFileAndModSettleTool tsFileAndModSettleTool = new TsFileAndModSettleTool();

    private TsFileAndModSettleTool() {
    }

    public static TsFileAndModSettleTool getInstance() {
        return tsFileAndModSettleTool;
    }

    public static void main(String[] args) {
        TsFileResource resource;
        HashMap<String, TsFileResource> oldTsFileResources = new HashMap<String, TsFileResource>();
        TsFileAndModSettleTool.findFilesToBeRecovered();
        for (Map.Entry<String, Integer> entry : TsFileAndModSettleTool.getInstance().recoverSettleFileMap.entrySet()) {
            String path = entry.getKey();
            resource = new TsFileResource(new File(path));
            resource.setStatus(TsFileResourceStatus.CLOSED);
            oldTsFileResources.put(resource.getTsFile().getName(), resource);
        }
        List<File> tsFiles = TsFileAndModSettleTool.checkArgs(args);
        for (File file : tsFiles) {
            if (oldTsFileResources.containsKey(file.getName()) || !new File(file + ".resource").exists()) continue;
            resource = new TsFileResource(file);
            resource.setStatus(TsFileResourceStatus.CLOSED);
            oldTsFileResources.put(file.getName(), resource);
        }
        System.out.println("Totally find " + oldTsFileResources.size() + " tsFiles to be settled, including " + TsFileAndModSettleTool.getInstance().recoverSettleFileMap.size() + " tsFiles to be recovered.");
        TsFileAndModSettleTool.settleTsFilesAndMods(oldTsFileResources);
    }

    public static List<File> checkArgs(String[] args) {
        String filePath = "test.tsfile";
        ArrayList<File> files = new ArrayList<File>();
        if (args.length == 0) {
            return null;
        }
        for (String arg : args) {
            if (arg.endsWith(".tsfile")) {
                File f = new File(arg);
                if (!f.exists()) {
                    logger.warn("Cannot find TsFile : " + arg);
                    continue;
                }
                files.add(f);
                continue;
            }
            List<File> tmpFiles = TsFileAndModSettleTool.getAllFilesInOneDirBySuffix(arg, ".tsfile");
            files.addAll(tmpFiles);
        }
        return files;
    }

    private static List<File> getAllFilesInOneDirBySuffix(String dirPath, String suffix) {
        File dir = new File(dirPath);
        if (!dir.isDirectory()) {
            logger.warn("It's not a directory path : " + dirPath);
            return Collections.emptyList();
        }
        if (!dir.exists()) {
            logger.warn("Cannot find Directory : " + dirPath);
            return Collections.emptyList();
        }
        ArrayList<File> tsFiles = new ArrayList<File>(Arrays.asList(FSFactoryProducer.getFSFactory().listFilesBySuffix(dirPath, suffix)));
        File[] tmpFiles = dir.listFiles();
        if (tmpFiles != null) {
            for (File f : tmpFiles) {
                if (!f.isDirectory()) continue;
                tsFiles.addAll(TsFileAndModSettleTool.getAllFilesInOneDirBySuffix(f.getAbsolutePath(), suffix));
            }
        }
        return tsFiles;
    }

    public static void settleTsFilesAndMods(Map<String, TsFileResource> resourcesToBeSettled) {
        int successCount = 0;
        HashMap<String, ArrayList<TsFileResource>> newTsFileResources = new HashMap<String, ArrayList<TsFileResource>>();
        SettleLog.createSettleLog();
        for (Map.Entry<String, TsFileResource> entry : resourcesToBeSettled.entrySet()) {
            TsFileResource resourceToBeSettled = entry.getValue();
            ArrayList<TsFileResource> settledTsFileResources = new ArrayList();
            try {
                TsFileAndModSettleTool tsFileAndModSettleTool = TsFileAndModSettleTool.getInstance();
                System.out.println("Start settling for tsFile : " + resourceToBeSettled.getTsFilePath());
                if (tsFileAndModSettleTool.isSettledFileGenerated(resourceToBeSettled)) {
                    settledTsFileResources = tsFileAndModSettleTool.findSettledFile(resourceToBeSettled);
                    newTsFileResources.put(resourceToBeSettled.getTsFile().getName(), settledTsFileResources);
                } else {
                    SettleLog.writeSettleLog(resourceToBeSettled.getTsFilePath() + "," + (Object)((Object)SettleLog.SettleCheckStatus.BEGIN_SETTLE_FILE));
                    tsFileAndModSettleTool.settleOneTsFileAndMod(resourceToBeSettled, settledTsFileResources);
                    SettleLog.writeSettleLog(resourceToBeSettled.getTsFilePath() + "," + (Object)((Object)SettleLog.SettleCheckStatus.AFTER_SETTLE_FILE));
                    newTsFileResources.put(resourceToBeSettled.getTsFile().getName(), settledTsFileResources);
                }
                TsFileAndModSettleTool.moveNewTsFile(resourceToBeSettled, settledTsFileResources);
                SettleLog.writeSettleLog(resourceToBeSettled.getTsFilePath() + "," + (Object)((Object)SettleLog.SettleCheckStatus.SETTLE_SUCCESS));
                System.out.println("Finish settling successfully for tsFile : " + resourceToBeSettled.getTsFilePath());
                ++successCount;
            }
            catch (Exception e) {
                System.out.println("Meet error while settling the tsFile : " + resourceToBeSettled.getTsFilePath());
                e.printStackTrace();
            }
        }
        if (resourcesToBeSettled.size() == successCount) {
            SettleLog.closeLogWriter();
            System.out.println("Finish settling all tsfiles Successfully!");
        } else {
            System.out.println("Finish Settling, " + (resourcesToBeSettled.size() - successCount) + " tsfiles meet errors.");
        }
    }

    public void settleOneTsFileAndMod(TsFileResource resourceToBeSettled, List<TsFileResource> settledResources) throws WriteProcessException, IllegalPathException, IOException {
        if (!resourceToBeSettled.isClosed()) {
            logger.warn("The tsFile {} should be sealed when rewritting.", (Object)resourceToBeSettled.getTsFilePath());
            return;
        }
        if (!resourceToBeSettled.getModFile().exists()) {
            return;
        }
        try (TsFileRewriteTool tsFileRewriteTool = new TsFileRewriteTool(resourceToBeSettled);){
            tsFileRewriteTool.parseAndRewriteFile(settledResources);
        }
        if (settledResources.size() == 0) {
            resourceToBeSettled.setStatus(TsFileResourceStatus.DELETED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void findFilesToBeRecovered() {
        if (FSFactoryProducer.getFSFactory().getFile(SettleLog.getSettleLogPath()).exists()) {
            try (BufferedReader settleLogReader = new BufferedReader(new FileReader(FSFactoryProducer.getFSFactory().getFile(SettleLog.getSettleLogPath())));){
                String line = null;
                while ((line = settleLogReader.readLine()) != null && !"".equals(line)) {
                    String oldFilePath = line.split(",")[0];
                    int settleCheckStatus = Integer.parseInt(line.split(",")[1]);
                    if (settleCheckStatus == SettleLog.SettleCheckStatus.SETTLE_SUCCESS.getCheckStatus()) {
                        TsFileAndModSettleTool.getInstance().recoverSettleFileMap.remove(oldFilePath);
                        continue;
                    }
                    TsFileAndModSettleTool.getInstance().recoverSettleFileMap.put(oldFilePath, settleCheckStatus);
                }
            }
            catch (IOException e) {
                logger.error("meet error when reading settle log, log path:{}", (Object)SettleLog.getSettleLogPath(), (Object)e);
            }
            finally {
                FSFactoryProducer.getFSFactory().getFile(SettleLog.getSettleLogPath()).delete();
            }
        }
    }

    public boolean isSettledFileGenerated(TsFileResource oldTsFileResource) {
        String oldFilePath = oldTsFileResource.getTsFilePath();
        return TsFileAndModSettleTool.getInstance().recoverSettleFileMap.containsKey(oldFilePath) && TsFileAndModSettleTool.getInstance().recoverSettleFileMap.get(oldFilePath).intValue() == SettleLog.SettleCheckStatus.AFTER_SETTLE_FILE.getCheckStatus();
    }

    public List<TsFileResource> findSettledFile(TsFileResource resourceToBeSettled) throws IOException {
        ArrayList<TsFileResource> settledTsFileResources = new ArrayList<TsFileResource>();
        SettleLog.writeSettleLog(resourceToBeSettled.getTsFilePath() + "," + (Object)((Object)SettleLog.SettleCheckStatus.BEGIN_SETTLE_FILE));
        File[] tmpFiles = resourceToBeSettled.getTsFile().getParentFile().listFiles();
        if (tmpFiles != null) {
            for (File tempPartitionDir : tmpFiles) {
                if (!tempPartitionDir.isDirectory() || !FSFactoryProducer.getFSFactory().getFile(tempPartitionDir, resourceToBeSettled.getTsFile().getName() + ".resource").exists()) continue;
                TsFileResource settledTsFileResource = new TsFileResource(FSFactoryProducer.getFSFactory().getFile(tempPartitionDir, resourceToBeSettled.getTsFile().getName()));
                settledTsFileResource.deserialize();
                settledTsFileResources.add(settledTsFileResource);
            }
        }
        SettleLog.writeSettleLog(resourceToBeSettled.getTsFilePath() + "," + (Object)((Object)SettleLog.SettleCheckStatus.AFTER_SETTLE_FILE));
        return settledTsFileResources;
    }

    public static void moveNewTsFile(TsFileResource oldTsFileResource, List<TsFileResource> newTsFileResources) throws IOException {
        oldTsFileResource.removeModFile();
        File newPartitionDir = new File(oldTsFileResource.getTsFile().getParent() + File.separator + oldTsFileResource.getTimePartition());
        if (newTsFileResources.size() == 0) {
            if (oldTsFileResource.isDeleted()) {
                oldTsFileResource.remove();
            }
            if (newPartitionDir.exists()) {
                newPartitionDir.delete();
            }
            return;
        }
        FSFactory fsFactory = FSFactoryProducer.getFSFactory();
        File oldTsFile = oldTsFileResource.getTsFile();
        boolean isOldFileExisted = oldTsFile.exists();
        oldTsFile.delete();
        for (TsFileResource newTsFileResource : newTsFileResources) {
            newPartitionDir = new File(oldTsFileResource.getTsFile().getParent() + File.separator + newTsFileResource.getTimePartition());
            if (!isOldFileExisted) {
                newTsFileResource.remove();
            } else {
                File newTsFile = newTsFileResource.getTsFile();
                fsFactory.moveFile(newTsFile, oldTsFile);
                newTsFileResource.setFile(fsFactory.getFile(oldTsFile.getParent(), newTsFile.getName()));
                newTsFileResource.setStatus(TsFileResourceStatus.CLOSED);
                try {
                    newTsFileResource.serialize();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                File tmpResourceFile = fsFactory.getFile(newPartitionDir, newTsFile.getName() + ".resource");
                if (tmpResourceFile.exists()) {
                    tmpResourceFile.delete();
                }
            }
            if (!newPartitionDir.exists()) continue;
            newPartitionDir.delete();
        }
    }

    public static void clearRecoverSettleFileMap() {
        TsFileAndModSettleTool.getInstance().recoverSettleFileMap.clear();
    }
}

