/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.series;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.metadata.path.AlignedPath;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.filter.TsFileFilter;
import org.apache.iotdb.db.query.reader.series.SeriesReader;
import org.apache.iotdb.db.query.reader.universal.AlignedDescPriorityMergeReader;
import org.apache.iotdb.db.query.reader.universal.AlignedPriorityMergeReader;
import org.apache.iotdb.db.query.reader.universal.DescPriorityMergeReader;
import org.apache.iotdb.db.query.reader.universal.PriorityMergeReader;
import org.apache.iotdb.db.utils.FileLoaderUtils;
import org.apache.iotdb.tsfile.file.metadata.AlignedTimeSeriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public class AlignedSeriesReader
extends SeriesReader {
    public AlignedSeriesReader(PartialPath seriesPath, Set<String> allSensors, TSDataType dataType, QueryContext context, QueryDataSource dataSource, Filter timeFilter, Filter valueFilter, TsFileFilter fileFilter, boolean ascending) {
        super(seriesPath, allSensors, dataType, context, dataSource, timeFilter, valueFilter, fileFilter, ascending);
    }

    public AlignedSeriesReader(PartialPath seriesPath, Set<String> allSensors, TSDataType dataType, QueryContext context, List<TsFileResource> seqFileResource, List<TsFileResource> unseqFileResource, Filter timeFilter, Filter valueFilter, boolean ascending) {
        super(seriesPath, allSensors, dataType, context, seqFileResource, unseqFileResource, timeFilter, valueFilter, ascending);
    }

    @Override
    protected PriorityMergeReader getPriorityMergeReader() {
        return new AlignedPriorityMergeReader();
    }

    @Override
    protected DescPriorityMergeReader getDescPriorityMergeReader() {
        return new AlignedDescPriorityMergeReader();
    }

    protected AlignedTimeSeriesMetadata loadTimeSeriesMetadata(TsFileResource resource, PartialPath seriesPath, QueryContext context, Filter filter, Set<String> allSensors) throws IOException {
        return FileLoaderUtils.loadTimeSeriesMetadata(resource, (AlignedPath)seriesPath, context, filter);
    }
}

