/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.externalsort;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.runtime.StorageEngineFailureException;
import org.apache.iotdb.db.query.externalsort.ExternalSortJob;
import org.apache.iotdb.db.query.externalsort.ExternalSortJobEngine;
import org.apache.iotdb.db.query.externalsort.ExternalSortJobPart;
import org.apache.iotdb.db.query.externalsort.ExternalSortJobScheduler;
import org.apache.iotdb.db.query.externalsort.MultiSourceExternalSortJobPart;
import org.apache.iotdb.db.query.externalsort.SingleSourceExternalSortJobPart;
import org.apache.iotdb.db.query.externalsort.adapter.ByTimestampReaderAdapter;
import org.apache.iotdb.db.query.reader.chunk.ChunkReaderWrap;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.tsfile.read.reader.IPointReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleExternalSortEngine
implements ExternalSortJobEngine {
    private ExternalSortJobScheduler scheduler;
    private String queryDir = IoTDBDescriptor.getInstance().getConfig().getQueryDir() + File.separator;
    private int minExternalSortSourceCount = IoTDBDescriptor.getInstance().getConfig().getExternalSortThreshold();
    private boolean enableExternalSort = IoTDBDescriptor.getInstance().getConfig().isEnableExternalSort();
    private static final Logger logger = LoggerFactory.getLogger(SimpleExternalSortEngine.class);

    private SimpleExternalSortEngine() {
        this.scheduler = ExternalSortJobScheduler.getInstance();
        try {
            FileUtils.deleteDirectory((File)new File(this.queryDir));
            FileUtils.forceMkdir((File)new File(this.queryDir));
        }
        catch (IOException e) {
            throw new StorageEngineFailureException(e);
        }
    }

    @Override
    public List<IPointReader> executeForIPointReader(long queryId, List<ChunkReaderWrap> chunkReaderWraps) throws IOException {
        if (!this.enableExternalSort || chunkReaderWraps.size() < this.minExternalSortSourceCount) {
            return this.generateIPointReader(chunkReaderWraps, 0, chunkReaderWraps.size());
        }
        if (logger.isInfoEnabled()) {
            logger.info("query {} measurement {} uses external sort.", (Object)queryId, (Object)chunkReaderWraps.get(0).getMeasurementUid());
        }
        ExternalSortJob job = this.createJob(queryId, chunkReaderWraps);
        return job.executeForIPointReader();
    }

    @Override
    public List<IReaderByTimestamp> executeForByTimestampReader(long queryId, List<ChunkReaderWrap> chunkReaderWraps) throws IOException {
        if (!this.enableExternalSort || chunkReaderWraps.size() < this.minExternalSortSourceCount) {
            return this.generateIReaderByTimestamp(chunkReaderWraps, 0, chunkReaderWraps.size());
        }
        if (logger.isInfoEnabled()) {
            logger.info("query {} measurement {} uses external sort.", (Object)queryId, (Object)chunkReaderWraps.get(0).getMeasurementUid());
        }
        ExternalSortJob job = this.createJob(queryId, chunkReaderWraps);
        return this.convert(job.executeForIPointReader());
    }

    @Override
    public ExternalSortJob createJob(long queryId, List<ChunkReaderWrap> readerWrapList) {
        long jobId = this.scheduler.genJobId();
        ArrayList<ExternalSortJobPart> ret = new ArrayList<ExternalSortJobPart>();
        for (ChunkReaderWrap readerWrap : readerWrapList) {
            ret.add(new SingleSourceExternalSortJobPart(readerWrap));
        }
        int partId = 0;
        while (ret.size() >= this.minExternalSortSourceCount) {
            ArrayList<MultiSourceExternalSortJobPart> tmpPartList = new ArrayList<MultiSourceExternalSortJobPart>();
            int i = 0;
            while (i < ret.size()) {
                int toIndex = Math.min(i + this.minExternalSortSourceCount, ret.size());
                List<ExternalSortJobPart> partGroup = ret.subList(i, toIndex);
                i = toIndex;
                String tmpFilePath = this.queryDir + jobId + "_" + partId;
                MultiSourceExternalSortJobPart part = new MultiSourceExternalSortJobPart(queryId, tmpFilePath, partGroup);
                tmpPartList.add(part);
                ++partId;
            }
            ret = tmpPartList;
        }
        return new ExternalSortJob(ret);
    }

    String getQueryDir() {
        return this.queryDir;
    }

    void setQueryDir(String queryDir) {
        this.queryDir = queryDir;
    }

    int getMinExternalSortSourceCount() {
        return this.minExternalSortSourceCount;
    }

    void setMinExternalSortSourceCount(int minExternalSortSourceCount) {
        this.minExternalSortSourceCount = minExternalSortSourceCount;
    }

    private List<IPointReader> generateIPointReader(List<ChunkReaderWrap> readerWraps, int start, int size) throws IOException {
        ArrayList<IPointReader> pointReaderList = new ArrayList<IPointReader>();
        for (int i = start; i < start + size; ++i) {
            pointReaderList.add(readerWraps.get(i).getIPointReader());
        }
        return pointReaderList;
    }

    private List<IReaderByTimestamp> generateIReaderByTimestamp(List<ChunkReaderWrap> readerWraps, int start, int size) throws IOException {
        ArrayList<IReaderByTimestamp> readerByTimestampList = new ArrayList<IReaderByTimestamp>();
        for (int i = start; i < start + size; ++i) {
            readerByTimestampList.add(readerWraps.get(i).getIReaderByTimestamp());
        }
        return readerByTimestampList;
    }

    private List<IReaderByTimestamp> convert(List<IPointReader> pointReaderList) {
        ArrayList<IReaderByTimestamp> readerByTimestampList = new ArrayList<IReaderByTimestamp>();
        for (IPointReader pointReader : pointReaderList) {
            readerByTimestampList.add(new ByTimestampReaderAdapter(pointReader));
        }
        return readerByTimestampList;
    }

    public static SimpleExternalSortEngine getInstance() {
        return SimpleExternalSortJobEngineHelper.INSTANCE;
    }

    private static class SimpleExternalSortJobEngineHelper {
        private static final SimpleExternalSortEngine INSTANCE = new SimpleExternalSortEngine();

        private SimpleExternalSortJobEngineHelper() {
        }
    }
}

