/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.executor.fill;

import java.io.IOException;
import java.util.Calendar;
import java.util.Set;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.SessionManager;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;

public abstract class IFill {
    protected long queryStartTime;
    protected long queryEndTime;
    protected TSDataType dataType;
    protected boolean isBeforeByMonth = false;
    protected long beforeRange = 0L;
    protected boolean isAfterByMonth = false;
    protected long afterRange = 0L;

    public IFill(TSDataType dataType, long queryStartTime) {
        this.dataType = dataType;
        this.queryStartTime = queryStartTime;
    }

    public IFill() {
    }

    public abstract IFill copy();

    public abstract void configureFill(PartialPath var1, TSDataType var2, long var3, Set<String> var5, QueryContext var6) throws QueryProcessException, StorageEngineException;

    public abstract TimeValuePair getFillResult() throws IOException, QueryProcessException, StorageEngineException;

    public TSDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(TSDataType dataType) {
        this.dataType = dataType;
    }

    public void setQueryStartTime(long queryStartTime) {
        this.queryStartTime = queryStartTime;
    }

    public long getQueryStartTime() {
        return this.queryStartTime;
    }

    public long getQueryEndTime() {
        return this.queryEndTime;
    }

    abstract void constructFilter();

    public boolean insideBeforeRange(long previous, long startTime) {
        if (this.isBeforeByMonth) {
            return previous >= this.slideMonth(startTime, (int)(-this.beforeRange / 2592000000L));
        }
        return previous >= startTime - this.beforeRange;
    }

    public boolean insideAfterRange(long next, long startTime) {
        if (this.isAfterByMonth) {
            return next <= this.slideMonth(startTime, (int)(this.afterRange / 2592000000L));
        }
        return next <= startTime + this.afterRange;
    }

    public void convertRange(long startTime, long endTime) {
        this.queryStartTime = this.beforeRange > 0L ? (this.isBeforeByMonth ? this.slideMonth(startTime, (int)(-this.beforeRange / 2592000000L)) : startTime - this.beforeRange) : startTime;
        this.queryEndTime = this.afterRange > 0L ? (this.isAfterByMonth ? this.slideMonth(endTime, (int)(this.afterRange / 2592000000L)) : endTime + this.afterRange) : endTime;
    }

    public long getBeforeRange() {
        return this.beforeRange;
    }

    public void setBeforeRange(long beforeRange) {
        this.beforeRange = beforeRange;
    }

    public long getAfterRange() {
        return this.afterRange;
    }

    public void setAfterRange(long afterRange) {
        this.afterRange = afterRange;
    }

    protected long slideMonth(long startTime, int monthNum) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(SessionManager.getInstance().getSessionTimeZone());
        calendar.setTimeInMillis(startTime);
        calendar.add(2, monthNum);
        return calendar.getTimeInMillis();
    }
}

