/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.db.qp.physical.crud.UDTFPlan;
import org.apache.iotdb.db.query.dataset.IUDFInputDataSet;
import org.apache.iotdb.db.query.dataset.RawQueryDataSetWithoutValueFilter;
import org.apache.iotdb.db.query.reader.series.ManagedSeriesReader;
import org.apache.iotdb.tsfile.read.common.Path;

public class UDFRawQueryInputDataSetWithoutValueFilter
extends RawQueryDataSetWithoutValueFilter
implements IUDFInputDataSet {
    public UDFRawQueryInputDataSetWithoutValueFilter(long queryId, UDTFPlan queryPlan, List<ManagedSeriesReader> readers) throws IOException, InterruptedException {
        super(queryId, queryPlan, readers);
    }

    @Override
    protected RawQueryDataSetWithoutValueFilter.ReadTask generateReadTaskForGivenReader(ManagedSeriesReader reader, int seriesIndex) {
        return new RawQueryDataSetWithoutValueFilter.ReadTask(reader, this.blockingQueueArray[seriesIndex], ((Path)this.paths.get(seriesIndex)).getFullPath(), null, 0, 0);
    }

    @Override
    public boolean hasNextRowInObjects() {
        return !this.timeHeap.isEmpty();
    }

    @Override
    public Object[] nextRowInObjects() throws IOException {
        int seriesNumber = this.seriesReaderList.size();
        long minTime = this.timeHeap.pollFirst();
        Object[] rowInObjects = new Object[seriesNumber + 1];
        rowInObjects[seriesNumber] = minTime;
        for (int seriesIndex = 0; seriesIndex < seriesNumber; ++seriesIndex) {
            if (this.cachedBatchDataArray[seriesIndex] == null || !this.cachedBatchDataArray[seriesIndex].hasCurrent() || this.cachedBatchDataArray[seriesIndex].currentTime() != minTime) continue;
            rowInObjects[seriesIndex] = this.cachedBatchDataArray[seriesIndex].currentValue();
            super.cacheNext(seriesIndex);
        }
        return rowInObjects;
    }
}

