/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.metadata.path.AlignedPath;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.query.control.QueryTimeManager;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;

public class QueryContext {
    private final Map<String, Map<String, List<Modification>>> filePathModCache = new ConcurrentHashMap<String, Map<String, List<Modification>>>();
    private final Map<String, List<Modification>> fileModCache = new HashMap<String, List<Modification>>();
    private long queryId;
    private long queryTimeLowerBound = Long.MIN_VALUE;
    private boolean debug;
    private boolean enableTracing = false;
    private static final int MAX_STATEMENT_LENGTH = 64;
    private long startTime;
    private String statement;
    private long timeout;
    private volatile boolean isInterrupted = false;

    public QueryContext() {
    }

    public QueryContext(long queryId) {
        this(queryId, false, System.currentTimeMillis(), "", 0L);
    }

    public QueryContext(long queryId, boolean debug, long startTime, String statement, long timeout) {
        this.queryId = queryId;
        this.debug = debug;
        this.startTime = startTime;
        this.statement = statement;
        this.timeout = timeout;
        QueryTimeManager.getInstance().registerQuery(this);
    }

    public List<Modification> getPathModifications(ModificationFile modFile, PartialPath path) {
        if (!modFile.exists()) {
            return Collections.emptyList();
        }
        Map fileModifications = this.filePathModCache.computeIfAbsent(modFile.getFilePath(), k -> new ConcurrentHashMap());
        return fileModifications.computeIfAbsent(path.getFullPath(), k -> {
            List allModifications = this.fileModCache.get(modFile.getFilePath());
            if (allModifications == null) {
                allModifications = (List)modFile.getModifications();
                this.fileModCache.put(modFile.getFilePath(), allModifications);
            }
            ArrayList finalPathModifications = new ArrayList();
            if (!allModifications.isEmpty()) {
                allModifications.forEach(modification -> {
                    if (modification.getPath().matchFullPath(path)) {
                        finalPathModifications.add(modification);
                    }
                });
            }
            return finalPathModifications;
        });
    }

    public List<List<Modification>> getPathModifications(ModificationFile modFile, AlignedPath path) {
        int n = path.getMeasurementList().size();
        ArrayList<List<Modification>> ans = new ArrayList<List<Modification>>(n);
        for (int i = 0; i < n; ++i) {
            ans.add(this.getPathModifications(modFile, path.getPathWithMeasurement(i)));
        }
        return ans;
    }

    public long getQueryId() {
        return this.queryId;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isEnableTracing() {
        return this.enableTracing;
    }

    public void setEnableTracing(boolean enableTracing) {
        this.enableTracing = enableTracing;
    }

    public long getQueryTimeLowerBound() {
        return this.queryTimeLowerBound;
    }

    public void setQueryTimeLowerBound(long queryTimeLowerBound) {
        this.queryTimeLowerBound = queryTimeLowerBound;
    }

    public boolean chunkNotSatisfy(IChunkMetadata chunkMetaData) {
        return chunkMetaData.getEndTime() < this.queryTimeLowerBound;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getStatement() {
        return this.statement;
    }

    public QueryContext setStartTime(long startTime) {
        this.startTime = startTime;
        return this;
    }

    public void getStatement(String statement) {
        this.statement = statement;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public QueryContext setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public QueryContext setStatement(String statement) {
        this.statement = statement.length() <= 64 ? statement : statement.substring(0, 32) + "..." + statement.substring(statement.length() - 32);
        return this;
    }

    public void setInterrupted(boolean interrupted) {
        this.isInterrupted = interrupted;
    }

    public boolean isInterrupted() {
        return this.isInterrupted;
    }
}

