/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.cross.rewrite;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.CompactionTaskManager;
import org.apache.iotdb.db.engine.compaction.cross.AbstractCrossSpaceCompactionSelector;
import org.apache.iotdb.db.engine.compaction.cross.CrossSpaceCompactionTaskFactory;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.manage.CrossSpaceCompactionResource;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.selector.ICrossSpaceMergeFileSelector;
import org.apache.iotdb.db.engine.compaction.inner.utils.InnerSpaceCompactionUtils;
import org.apache.iotdb.db.engine.compaction.task.AbstractCompactionTask;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.rescon.SystemInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RewriteCrossSpaceCompactionSelector
extends AbstractCrossSpaceCompactionSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();

    public RewriteCrossSpaceCompactionSelector(String logicalStorageGroupName, String virtualStorageGroupId, String storageGroupDir, long timePartition, TsFileManager tsFileManager, CrossSpaceCompactionTaskFactory taskFactory) {
        super(logicalStorageGroupName, virtualStorageGroupId, storageGroupDir, timePartition, tsFileManager, taskFactory);
    }

    @Override
    public void selectAndSubmit() {
        if (CompactionTaskManager.currentTaskNum.get() >= config.getConcurrentCompactionThread() || !config.isEnableCrossSpaceCompaction()) {
            return;
        }
        Iterator seqIterator = this.sequenceFileList.iterator();
        Iterator unSeqIterator = this.unsequenceFileList.iterator();
        ArrayList<TsFileResource> seqFileList = new ArrayList<TsFileResource>();
        ArrayList<TsFileResource> unSeqFileList = new ArrayList<TsFileResource>();
        while (seqIterator.hasNext()) {
            seqFileList.add((TsFileResource)seqIterator.next());
        }
        while (unSeqIterator.hasNext()) {
            unSeqFileList.add((TsFileResource)unSeqIterator.next());
        }
        if (seqFileList.isEmpty() || unSeqFileList.isEmpty()) {
            return;
        }
        long budget = SystemInfo.getInstance().getMemorySizeForCompaction() / (long)config.getConcurrentCompactionThread();
        long timeLowerBound = System.currentTimeMillis() - Long.MAX_VALUE;
        CrossSpaceCompactionResource mergeResource = new CrossSpaceCompactionResource(seqFileList, unSeqFileList, timeLowerBound);
        ICrossSpaceMergeFileSelector fileSelector = InnerSpaceCompactionUtils.getCrossSpaceFileSelector(budget, mergeResource);
        try {
            List[] mergeFiles = fileSelector.select();
            List<Long> memoryCost = fileSelector.getMemoryCost();
            mergeResource.clear();
            if (mergeFiles.length == 0) {
                if (mergeResource.getUnseqFiles().size() > 0) {
                    LOGGER.warn("{} cannot select merge candidates under the budget {}", (Object)this.logicalStorageGroupName, (Object)budget);
                }
                return;
            }
            LOGGER.info("select files for cross compaction, sequence files: {}, unsequence files {}, memory cost is {}", new Object[]{mergeFiles[0], mergeFiles[1], memoryCost.get(0)});
            if (mergeFiles[0].size() > 0 && mergeFiles[1].size() > 0) {
                AbstractCompactionTask compactionTask = this.taskFactory.createTask(this.logicalStorageGroupName, this.virtualGroupId, this.timePartition, this.tsFileManager, mergeFiles[0], mergeFiles[1], memoryCost.get(0));
                CompactionTaskManager.getInstance().addTaskToWaitingQueue(compactionTask);
                LOGGER.info("{} [Compaction] submit a task with {} sequence file and {} unseq files", new Object[]{this.logicalStorageGroupName + "-" + this.virtualGroupId, mergeResource.getSeqFiles().size(), mergeResource.getUnseqFiles().size()});
            }
        }
        catch (Exception e) {
            LOGGER.error("{} cannot select file for cross space compaction", (Object)this.logicalStorageGroupName, (Object)e);
        }
    }
}

