/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FilteredMap
implements Map<String, Object> {
    private static final String FILTERED_PLACEHOLDER = "[FILTERED]";
    private final Map<String, Object> filteredCopy;
    private final Collection<String> keyFilters = new ArrayList<String>();

    public FilteredMap(Map<String, Object> map, Collection<String> keyFilters) {
        this.keyFilters.addAll(keyFilters);
        this.filteredCopy = this.createCopy(map);
    }

    private Map<String, Object> createCopy(Map<? extends String, ?> map) {
        HashMap<String, Object> copy = new HashMap<String, Object>();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            if (entry.getValue() == null) {
                copy.put(entry.getKey(), entry.getValue());
                continue;
            }
            Object transformedValue = this.transformEntry(entry.getKey(), entry.getValue());
            copy.put(entry.getKey(), transformedValue);
        }
        return copy;
    }

    @Override
    public int size() {
        return this.filteredCopy.size();
    }

    @Override
    public boolean isEmpty() {
        return this.filteredCopy.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.filteredCopy.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.filteredCopy.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.filteredCopy.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        if (value == null) {
            return this.filteredCopy.put(key, null);
        }
        Object transformedValue = this.transformEntry(key, value);
        return this.filteredCopy.put(key, transformedValue);
    }

    @Override
    public Object remove(Object key) {
        return this.filteredCopy.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ?> mapValues) {
        Map<String, Object> copy = this.createCopy(mapValues);
        this.filteredCopy.putAll(copy);
    }

    @Override
    public void clear() {
        this.filteredCopy.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.filteredCopy.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.filteredCopy.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.filteredCopy.entrySet();
    }

    private Object transformEntry(Object key, Object value) {
        if (value instanceof Map) {
            return new FilteredMap((Map)value, this.keyFilters);
        }
        return this.shouldFilterKey((String)key) ? FILTERED_PLACEHOLDER : value;
    }

    private boolean shouldFilterKey(String key) {
        if (this.keyFilters == null || key == null) {
            return false;
        }
        for (String filter : this.keyFilters) {
            if (!key.contains(filter)) continue;
            return true;
        }
        return false;
    }
}

