/*
 * Decompiled with CFR 0.152.
 */
package com.librato.metrics.reporter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceInformation {
    static final Logger log = LoggerFactory.getLogger(SourceInformation.class);
    public final String source;
    public final String name;

    public static SourceInformation from(Pattern sourceRegex, String name) {
        if (sourceRegex == null) {
            return new SourceInformation(null, name);
        }
        Matcher matcher = sourceRegex.matcher(name);
        if (matcher.groupCount() != 1) {
            log.error("Source regex matcher must define a group");
            return new SourceInformation(null, name);
        }
        if (!matcher.find()) {
            return new SourceInformation(null, name);
        }
        String source = matcher.group(1);
        int endPos = matcher.toMatchResult().end();
        if (endPos >= name.length()) {
            log.error("Source '{}' matched the whole metric name. Metric name cannot be empty");
            return new SourceInformation(null, name);
        }
        String newName = name.substring(endPos);
        return new SourceInformation(source, newName);
    }

    public SourceInformation(String source, String name) {
        this.source = source;
        this.name = name;
    }
}

