/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.log.manage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.cluster.log.Log;
import org.apache.iotdb.cluster.log.Snapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnCommittedEntryManager {
    private static final Logger logger = LoggerFactory.getLogger(UnCommittedEntryManager.class);
    private List<Log> entries;
    private long offset;

    UnCommittedEntryManager(long offset) {
        this.offset = offset;
        this.entries = Collections.synchronizedList(new ArrayList());
    }

    long getFirstUnCommittedIndex() {
        return this.offset;
    }

    long maybeLastIndex() {
        int entryNum = this.entries.size();
        while (entryNum != 0) {
            try {
                return this.entries.get(entryNum - 1).getCurrLogIndex();
            }
            catch (IndexOutOfBoundsException e) {
                entryNum = this.entries.size();
            }
        }
        return -1L;
    }

    long maybeTerm(long index) {
        while (true) {
            int entryPos;
            if ((entryPos = (int)(index - this.offset)) < 0) {
                logger.debug("invalid unCommittedEntryManager maybeTerm : parameter: index({}) < offset({})", (Object)index, (Object)(index - (long)entryPos));
                return -1L;
            }
            long last = this.maybeLastIndex();
            if (last == -1L || index > last) {
                return -1L;
            }
            try {
                Log log = this.entries.get(entryPos);
                if (log.getCurrLogIndex() != index) continue;
                return log.getCurrLogTerm();
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                continue;
            }
            break;
        }
    }

    void stableTo(long index) {
        if (index < this.offset + (long)this.entries.size() && index >= this.offset) {
            this.entries.subList(0, (int)(index + 1L - this.offset)).clear();
            this.offset = index + 1L;
        }
    }

    void applyingSnapshot(Snapshot snapshot) {
        this.offset = snapshot.getLastLogIndex() + 1L;
        this.entries.clear();
    }

    void truncateAndAppend(List<Log> appendingEntries) {
        if (appendingEntries.isEmpty()) {
            return;
        }
        Log firstAppendingEntry = appendingEntries.get(0);
        Log lastAppendingEntry = appendingEntries.get(appendingEntries.size() - 1);
        if (this.maybeTerm(firstAppendingEntry.getCurrLogIndex()) == firstAppendingEntry.getCurrLogTerm() && this.maybeTerm(lastAppendingEntry.getCurrLogIndex()) == lastAppendingEntry.getCurrLogTerm()) {
            return;
        }
        long after = appendingEntries.get(0).getCurrLogIndex();
        long len = after - this.offset;
        if (len < 0L) {
            logger.error("The logs which first index is {} are going to truncate committed logs", (Object)after);
        } else if (len == (long)this.entries.size()) {
            this.entries.addAll(appendingEntries);
        } else {
            logger.info("truncate the entries after index {}", (Object)after);
            int truncateIndex = (int)(after - this.offset);
            if (truncateIndex < this.entries.size()) {
                this.entries.subList(truncateIndex, this.entries.size()).clear();
            }
            this.entries.addAll(appendingEntries);
        }
    }

    void truncateAndAppend(Log appendingEntry) {
        if (this.maybeTerm(appendingEntry.getCurrLogIndex()) == appendingEntry.getCurrLogTerm()) {
            return;
        }
        long after = appendingEntry.getCurrLogIndex();
        long len = after - this.offset;
        if (len < 0L) {
            logger.error("The logs which first index is {} are going to truncate committed logs", (Object)after);
        } else if (len == (long)this.entries.size()) {
            this.entries.add(appendingEntry);
        } else {
            logger.info("truncate the entries after index {}, append a new entry {}", (Object)after, (Object)appendingEntry);
            int truncateIndex = (int)(after - this.offset);
            if (truncateIndex < this.entries.size()) {
                this.entries.subList(truncateIndex, this.entries.size()).clear();
            }
            this.entries.add(appendingEntry);
        }
    }

    public List<Log> getEntries(long low, long high) {
        if (low > high) {
            if (logger.isDebugEnabled()) {
                logger.debug("invalid unCommittedEntryManager getEntries: parameter: low({}) > high({})", (Object)low, (Object)high);
            }
            return Collections.emptyList();
        }
        long upper = this.offset + (long)this.entries.size();
        if (low > upper) {
            logger.info("unCommittedEntryManager getEntries[{},{}) out of bound : [{},{}] , return empty ArrayList", new Object[]{low, high, this.offset, upper});
            return Collections.emptyList();
        }
        if (low < this.offset) {
            logger.debug("unCommittedEntryManager getEntries[{},{}) out of bound : [{},{}]", new Object[]{low, high, this.offset, upper});
            low = this.offset;
        }
        if (high > upper) {
            logger.info("unCommittedEntryManager getEntries[{},{}) out of bound : [{},{}] , adjust parameter 'high' to {}", new Object[]{low, high, this.offset, upper, upper});
            high = upper;
        }
        return this.entries.subList((int)(low - this.offset), (int)(high - this.offset));
    }

    UnCommittedEntryManager(long offset, List<Log> entries) {
        this.offset = offset;
        this.entries = entries;
    }

    List<Log> getAllEntries() {
        return this.entries;
    }
}

