/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicIntegerArray;
import org.apache.iotdb.db.concurrent.WrappedRunnable;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.query.control.QueryTimeManager;
import org.apache.iotdb.db.query.dataset.DirectNonAlignDataSet;
import org.apache.iotdb.db.query.pool.RawQueryReadTaskPoolManager;
import org.apache.iotdb.db.query.reader.series.ManagedSeriesReader;
import org.apache.iotdb.db.tools.watermark.WatermarkEncoder;
import org.apache.iotdb.service.rpc.thrift.TSQueryNonAlignDataSet;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonAlignEngineDataSet
extends QueryDataSet
implements DirectNonAlignDataSet {
    private List<ManagedSeriesReader> seriesReaderWithoutValueFilterList;
    private BlockingQueue<Pair<ByteBuffer, ByteBuffer>>[] blockingQueueArray;
    private boolean initialized = false;
    private AtomicIntegerArray offsetArray;
    private int limit;
    private AtomicIntegerArray alreadyReturnedRowNumArray;
    private BatchData[] cachedBatchData;
    private boolean[] noMoreDataInQueueArray;
    private int fetchSize;
    private static final int BLOCKING_QUEUE_CAPACITY = 5;
    private final long queryId;
    private volatile boolean interrupted = false;
    private static final RawQueryReadTaskPoolManager pool = RawQueryReadTaskPoolManager.getInstance();
    private static final Logger LOGGER = LoggerFactory.getLogger(NonAlignEngineDataSet.class);

    public NonAlignEngineDataSet(long queryId, List<PartialPath> paths, List<TSDataType> dataTypes, List<ManagedSeriesReader> readers) {
        super(new ArrayList<PartialPath>(paths), dataTypes);
        this.queryId = queryId;
        this.seriesReaderWithoutValueFilterList = readers;
        this.blockingQueueArray = new BlockingQueue[readers.size()];
        this.noMoreDataInQueueArray = new boolean[readers.size()];
        for (int i = 0; i < this.seriesReaderWithoutValueFilterList.size(); ++i) {
            this.blockingQueueArray[i] = new LinkedBlockingQueue<Pair<ByteBuffer, ByteBuffer>>(5);
        }
    }

    private void initLimit(int offset, int limit, int size) {
        int[] offsetArrayTemp = new int[size];
        Arrays.fill(offsetArrayTemp, offset);
        this.offsetArray = new AtomicIntegerArray(offsetArrayTemp);
        this.limit = limit;
        this.alreadyReturnedRowNumArray = new AtomicIntegerArray(size);
        this.cachedBatchData = new BatchData[size];
    }

    private void init(WatermarkEncoder encoder, int fetchSize) {
        QueryTimeManager.checkQueryAlive(this.queryId);
        this.initLimit(this.rowOffset, this.rowLimit, this.seriesReaderWithoutValueFilterList.size());
        this.fetchSize = fetchSize;
        for (int i = 0; i < this.seriesReaderWithoutValueFilterList.size(); ++i) {
            ManagedSeriesReader reader = this.seriesReaderWithoutValueFilterList.get(i);
            reader.setHasRemaining(true);
            reader.setManagedByQueryManager(true);
            pool.submit(new ReadTask(reader, this.blockingQueueArray[i], encoder, i));
        }
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TSQueryNonAlignDataSet fillBuffer(int fetchSize, WatermarkEncoder encoder) throws InterruptedException {
        if (!this.initialized) {
            this.init(encoder, fetchSize);
        }
        int seriesNum = this.seriesReaderWithoutValueFilterList.size();
        TSQueryNonAlignDataSet tsQueryNonAlignDataSet = new TSQueryNonAlignDataSet();
        ArrayList<ByteBuffer> timeBufferList = new ArrayList<ByteBuffer>(seriesNum);
        ArrayList<ByteBuffer> valueBufferList = new ArrayList<ByteBuffer>(seriesNum);
        for (int seriesIndex = 0; seriesIndex < seriesNum; ++seriesIndex) {
            Pair<ByteBuffer, ByteBuffer> timeValueByteBufferPair;
            if (!this.noMoreDataInQueueArray[seriesIndex]) {
                QueryTimeManager.checkQueryAlive(this.queryId);
                timeValueByteBufferPair = this.blockingQueueArray[seriesIndex].take();
                if (timeValueByteBufferPair.left == null || timeValueByteBufferPair.right == null) {
                    this.noMoreDataInQueueArray[seriesIndex] = true;
                    timeValueByteBufferPair.left = ByteBuffer.allocate(0);
                    timeValueByteBufferPair.right = ByteBuffer.allocate(0);
                }
            } else {
                timeBufferList.add(ByteBuffer.allocate(0));
                valueBufferList.add(ByteBuffer.allocate(0));
                continue;
            }
            timeBufferList.add((ByteBuffer)timeValueByteBufferPair.left);
            valueBufferList.add((ByteBuffer)timeValueByteBufferPair.right);
            ManagedSeriesReader managedSeriesReader = this.seriesReaderWithoutValueFilterList.get(seriesIndex);
            synchronized (managedSeriesReader) {
                ManagedSeriesReader reader;
                if (this.blockingQueueArray[seriesIndex].remainingCapacity() > 0 && !(reader = this.seriesReaderWithoutValueFilterList.get(seriesIndex)).isManagedByQueryManager() && reader.hasRemaining()) {
                    reader.setManagedByQueryManager(true);
                    pool.submit(new ReadTask(reader, this.blockingQueueArray[seriesIndex], encoder, seriesIndex));
                }
                continue;
            }
        }
        tsQueryNonAlignDataSet.setTimeList(timeBufferList);
        tsQueryNonAlignDataSet.setValueList(valueBufferList);
        return tsQueryNonAlignDataSet;
    }

    public boolean hasNextWithoutConstraint() {
        return false;
    }

    public RowRecord nextWithoutConstraint() {
        return null;
    }

    private class ReadTask
    extends WrappedRunnable {
        private final ManagedSeriesReader reader;
        private BlockingQueue<Pair<ByteBuffer, ByteBuffer>> blockingQueue;
        private WatermarkEncoder encoder;
        private int index;

        public ReadTask(ManagedSeriesReader reader, BlockingQueue<Pair<ByteBuffer, ByteBuffer>> blockingQueue, WatermarkEncoder encoder, int index) {
            this.reader = reader;
            this.blockingQueue = blockingQueue;
            this.encoder = encoder;
            this.index = index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runMayThrow() {
            PublicBAOS timeBAOS = new PublicBAOS();
            PublicBAOS valueBAOS = new PublicBAOS();
            try {
                if (NonAlignEngineDataSet.this.interrupted) {
                    return;
                }
                ManagedSeriesReader managedSeriesReader = this.reader;
                synchronized (managedSeriesReader) {
                    if (NonAlignEngineDataSet.this.cachedBatchData[this.index] != null && NonAlignEngineDataSet.this.cachedBatchData[this.index].hasCurrent() || this.reader.hasNextBatch()) {
                        BatchData batchData = NonAlignEngineDataSet.this.cachedBatchData[this.index] != null && NonAlignEngineDataSet.this.cachedBatchData[this.index].hasCurrent() ? NonAlignEngineDataSet.this.cachedBatchData[this.index] : this.reader.nextBatch();
                        int rowCount = 0;
                        while (rowCount < NonAlignEngineDataSet.this.fetchSize && (NonAlignEngineDataSet.this.limit <= 0 || NonAlignEngineDataSet.this.alreadyReturnedRowNumArray.get(this.index) < NonAlignEngineDataSet.this.limit)) {
                            if (batchData != null && batchData.hasCurrent()) {
                                if (NonAlignEngineDataSet.this.offsetArray.get(this.index) == 0) {
                                    long time = batchData.currentTime();
                                    ReadWriteIOUtils.write((long)time, (OutputStream)timeBAOS);
                                    TSDataType type = batchData.getDataType();
                                    switch (type) {
                                        case INT32: {
                                            int intValue = batchData.getInt();
                                            if (this.encoder != null && this.encoder.needEncode(time)) {
                                                intValue = this.encoder.encodeInt(intValue, time);
                                            }
                                            ReadWriteIOUtils.write((int)intValue, (OutputStream)valueBAOS);
                                            break;
                                        }
                                        case INT64: {
                                            long longValue = batchData.getLong();
                                            if (this.encoder != null && this.encoder.needEncode(time)) {
                                                longValue = this.encoder.encodeLong(longValue, time);
                                            }
                                            ReadWriteIOUtils.write((long)longValue, (OutputStream)valueBAOS);
                                            break;
                                        }
                                        case FLOAT: {
                                            float floatValue = batchData.getFloat();
                                            if (this.encoder != null && this.encoder.needEncode(time)) {
                                                floatValue = this.encoder.encodeFloat(floatValue, time);
                                            }
                                            ReadWriteIOUtils.write((float)floatValue, (OutputStream)valueBAOS);
                                            break;
                                        }
                                        case DOUBLE: {
                                            double doubleValue = batchData.getDouble();
                                            if (this.encoder != null && this.encoder.needEncode(time)) {
                                                doubleValue = this.encoder.encodeDouble(doubleValue, time);
                                            }
                                            ReadWriteIOUtils.write((double)doubleValue, (OutputStream)valueBAOS);
                                            break;
                                        }
                                        case BOOLEAN: {
                                            ReadWriteIOUtils.write((Boolean)batchData.getBoolean(), (OutputStream)valueBAOS);
                                            break;
                                        }
                                        case TEXT: {
                                            ReadWriteIOUtils.write((Binary)batchData.getBinary(), (OutputStream)valueBAOS);
                                            break;
                                        }
                                        default: {
                                            throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", type));
                                        }
                                    }
                                }
                            } else {
                                if (!this.reader.hasNextBatch()) break;
                                ((NonAlignEngineDataSet)NonAlignEngineDataSet.this).cachedBatchData[this.index] = batchData = this.reader.nextBatch();
                                continue;
                            }
                            batchData.next();
                            if (NonAlignEngineDataSet.this.offsetArray.get(this.index) == 0) {
                                ++rowCount;
                                if (NonAlignEngineDataSet.this.limit <= 0) continue;
                                NonAlignEngineDataSet.this.alreadyReturnedRowNumArray.incrementAndGet(this.index);
                                continue;
                            }
                            NonAlignEngineDataSet.this.offsetArray.decrementAndGet(this.index);
                        }
                        if (rowCount == 0) {
                            this.blockingQueue.put((Pair<ByteBuffer, ByteBuffer>)new Pair(null, null));
                            this.reader.setHasRemaining(false);
                            this.reader.setManagedByQueryManager(false);
                            return;
                        }
                        ByteBuffer timeBuffer = ByteBuffer.wrap(timeBAOS.getBuf());
                        timeBuffer.limit(timeBAOS.size());
                        ByteBuffer valueBuffer = ByteBuffer.wrap(valueBAOS.getBuf());
                        valueBuffer.limit(valueBAOS.size());
                        Pair timeValueBAOSPair = new Pair((Object)timeBuffer, (Object)valueBuffer);
                        this.blockingQueue.put((Pair<ByteBuffer, ByteBuffer>)timeValueBAOSPair);
                        if (this.blockingQueue.remainingCapacity() > 0) {
                            pool.submit(this);
                        } else {
                            this.reader.setManagedByQueryManager(false);
                        }
                        return;
                    }
                    this.blockingQueue.put((Pair<ByteBuffer, ByteBuffer>)new Pair(null, null));
                    this.reader.setHasRemaining(false);
                    this.reader.setManagedByQueryManager(false);
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("Interrupted while putting into the blocking queue: ", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (IOException e) {
                LOGGER.error("Something gets wrong while reading from the series reader: ", (Throwable)e);
            }
            catch (Exception e) {
                LOGGER.error("Something gets wrong: ", (Throwable)e);
            }
        }
    }
}

