/*
 * Decompiled with CFR 0.152.
 */
package me.tongfei.progressbar;

import java.time.Duration;
import java.time.Instant;

class ProgressState {
    String taskName;
    String extraMessage = "";
    boolean indefinite = false;
    long start;
    long current;
    long max;
    Instant startInstant = null;
    Duration elapsedBeforeStart = Duration.ZERO;
    volatile boolean alive = true;
    volatile boolean paused = false;

    ProgressState(String taskName, long initialMax, long startFrom, Duration elapsedBeforeStart) {
        this.taskName = taskName;
        this.max = initialMax;
        if (initialMax < 0L) {
            this.indefinite = true;
        }
        this.start = startFrom;
        this.current = startFrom;
        this.elapsedBeforeStart = elapsedBeforeStart;
        this.startInstant = Instant.now();
    }

    String getTaskName() {
        return this.taskName;
    }

    synchronized String getExtraMessage() {
        return this.extraMessage;
    }

    synchronized long getCurrent() {
        return this.current;
    }

    synchronized long getMax() {
        return this.max;
    }

    synchronized double getNormalizedProgress() {
        if (this.max <= 0L) {
            return 0.0;
        }
        if (this.current > this.max) {
            return 1.0;
        }
        return (double)this.current / (double)this.max;
    }

    synchronized void setAsDefinite() {
        this.indefinite = false;
    }

    synchronized void setAsIndefinite() {
        this.indefinite = true;
    }

    synchronized void maxHint(long n) {
        this.max = n;
    }

    synchronized void stepBy(long n) {
        this.current += n;
        if (this.current > this.max) {
            this.max = this.current;
        }
    }

    synchronized void stepTo(long n) {
        this.current = n;
        if (this.current > this.max) {
            this.max = this.current;
        }
    }

    synchronized void setExtraMessage(String msg) {
        this.extraMessage = msg;
    }

    synchronized void pause() {
        this.paused = true;
        this.start = this.current;
        this.elapsedBeforeStart = this.elapsedBeforeStart.plus(Duration.between(this.startInstant, Instant.now()));
    }

    synchronized void resume() {
        this.paused = false;
        this.startInstant = Instant.now();
    }

    synchronized void kill() {
        this.alive = false;
    }
}

