/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.jdbc;

import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iotdb.jdbc.Config;
import org.apache.iotdb.jdbc.Constant;
import org.apache.iotdb.jdbc.IoTDBConnectionParams;
import org.apache.iotdb.jdbc.IoTDBURLException;

public class Utils {
    static final Pattern URL_PATTERN = Pattern.compile("([^:]+):([0-9]{1,5})(/|\\?.*=.*(&.*=.*)*)?");
    static final String RPC_COMPRESS = "rpc_compress";

    static IoTDBConnectionParams parseUrl(String url, Properties info) throws IoTDBURLException {
        String subURL;
        IoTDBConnectionParams params = new IoTDBConnectionParams(url);
        if (url.trim().equalsIgnoreCase("jdbc:iotdb://")) {
            return params;
        }
        boolean isUrlLegal = false;
        Matcher matcher = null;
        if (url.startsWith("jdbc:iotdb://") && (matcher = URL_PATTERN.matcher(subURL = url.substring("jdbc:iotdb://".length()))).matches() && Utils.parseUrlParam(subURL, info)) {
            isUrlLegal = true;
        }
        if (!isUrlLegal) {
            throw new IoTDBURLException("Error url format, url should be jdbc:iotdb://anything:port/ or jdbc:iotdb://anything:port?property1=value1&property2=value2");
        }
        params.setHost(matcher.group(1));
        params.setPort(Integer.parseInt(matcher.group(2)));
        if (info.containsKey("user")) {
            params.setUsername(info.getProperty("user"));
        }
        if (info.containsKey("password")) {
            params.setPassword(info.getProperty("password"));
        }
        if (info.containsKey("thrift_default_buffer_capacity")) {
            params.setThriftDefaultBufferSize(Integer.parseInt(info.getProperty("thrift_default_buffer_capacity")));
        }
        if (info.containsKey("thrift_max_frame_size")) {
            params.setThriftMaxFrameSize(Integer.parseInt(info.getProperty("thrift_max_frame_size")));
        }
        if (info.containsKey("version")) {
            params.setVersion(Constant.Version.valueOf(info.getProperty("version")));
        }
        return params;
    }

    private static boolean parseUrlParam(String subURL, Properties info) {
        String[] params;
        if (!subURL.contains("?")) {
            return true;
        }
        String paramURL = subURL.substring(subURL.indexOf(63) + 1);
        block8: for (String tmpParam : params = paramURL.split("&")) {
            String[] paramSplit = tmpParam.split("=");
            if (paramSplit.length != 2) {
                return false;
            }
            String key = tmpParam.split("=")[0];
            String value = tmpParam.split("=")[1];
            switch (key) {
                case "rpc_compress": {
                    if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
                        Config.rpcThriftCompressionEnable = Boolean.parseBoolean(value);
                        continue block8;
                    }
                    return false;
                }
                case "version": {
                    info.put(key, value);
                    continue block8;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }
}

