/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.traverser.counter;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mtree.traverser.Traverser;
import org.apache.iotdb.db.metadata.path.PartialPath;

public class MeasurementGroupByLevelCounter
extends Traverser {
    private int groupByLevel;
    private Map<PartialPath, Integer> result = new HashMap<PartialPath, Integer>();
    private PartialPath path;

    public MeasurementGroupByLevelCounter(IMNode startNode, PartialPath path, int groupByLevel) throws MetadataException {
        super(startNode, path);
        this.groupByLevel = groupByLevel;
    }

    @Override
    protected boolean processInternalMatchedMNode(IMNode node, int idx, int level) throws MetadataException {
        if (level == this.groupByLevel) {
            this.path = node.getPartialPath();
            this.result.putIfAbsent(this.path, 0);
        }
        return false;
    }

    @Override
    protected boolean processFullMatchedMNode(IMNode node, int idx, int level) throws MetadataException {
        if (level == this.groupByLevel) {
            this.path = node.getPartialPath();
            this.result.putIfAbsent(this.path, 0);
        }
        if (!node.isMeasurement()) {
            return false;
        }
        if (level >= this.groupByLevel) {
            this.result.put(this.path, this.result.get(this.path) + 1);
        }
        return true;
    }

    public Map<PartialPath, Integer> getResult() {
        return this.result;
    }
}

