/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.archiving;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.iotdb.db.engine.archiving.ArchivingOperate;
import org.apache.iotdb.db.engine.archiving.ArchivingTask;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.metadata.logfile.MLogTxtWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchivingOperateWriter
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(MLogTxtWriter.class);
    private final File logFile;
    private FileOutputStream logFileOutStream;

    public ArchivingOperateWriter(String logFileName) throws FileNotFoundException {
        this(SystemFileFactory.INSTANCE.getFile(logFileName));
    }

    public ArchivingOperateWriter(File logFile) throws FileNotFoundException {
        this.logFile = logFile;
        if (!logFile.exists() && logFile.getParentFile() != null) {
            if (logFile.getParentFile().mkdirs()) {
                logger.info("created archiving log folder");
            } else {
                logger.info("create archiving log folder failed");
            }
        }
        this.logFileOutStream = new FileOutputStream(logFile, true);
    }

    public void log(ArchivingOperate.ArchivingOperateType type, ArchivingTask task) throws IOException {
        switch (type) {
            case SET: {
                ArchivingOperate operate = new ArchivingOperate(ArchivingOperate.ArchivingOperateType.SET, task);
                operate.serialize(this.logFileOutStream);
                break;
            }
            case CANCEL: 
            case START: 
            case PAUSE: 
            case RESUME: 
            case FINISHED: 
            case ERROR: {
                ArchivingOperate operate = new ArchivingOperate(type, task.getTaskId());
                operate.serialize(this.logFileOutStream);
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.logFileOutStream.close();
    }
}

