/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.util;

import com.azure.core.implementation.util.BinaryDataContent;
import com.azure.core.util.BinaryData;

public final class BinaryDataHelper {
    private static BinaryDataAccessor accessor;

    public static void setAccessor(BinaryDataAccessor binaryDataAccessor) {
        accessor = binaryDataAccessor;
    }

    public static BinaryData createBinaryData(BinaryDataContent content) {
        BinaryDataHelper.ensureAccessorSet();
        return accessor.createBinaryData(content);
    }

    public static BinaryDataContent getContent(BinaryData binaryData) {
        BinaryDataHelper.ensureAccessorSet();
        return accessor.getContent(binaryData);
    }

    private static void ensureAccessorSet() {
        if (accessor == null) {
            BinaryData.fromString("");
        }
    }

    public static interface BinaryDataAccessor {
        public BinaryData createBinaryData(BinaryDataContent var1);

        public BinaryDataContent getContent(BinaryData var1);
    }
}

